﻿using Hims.Shared.Dapper.Attributes;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Diagnostics;
using System.Text;

namespace Hims.Shared.UserModels
{
    public class CommonEncounterModel
    {
       
        public int CommonEncounterId { get; set; }
        /// <summary>
        /// Gets or sets provider id.
        /// </summary>
        public string? FamilyHistory { get; set; }
        /// <summary>
        /// Gets or sets reason.
        /// </summary>
        public string? ProblemList { get; set; }
        /// <summary>
        /// Gets or sets encrypted appointment id.
        /// </summary>
        public string? EncryptedAppointmentId { get; set; }
        public bool Active { get; set; }

        /// <summary>
        /// Gets or set consultant doctor.
        /// </summary>
        public string? BirthHistory { get; set; }

        /// <summary>
        /// Gets or sets appointment id.
        /// </summary>
        public int AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets appointment id.
        /// </summary>
        public int? PatientId { get; set; }
        /// <summary>
        /// Gets or sets created date.
        /// </summary>
        public DateTime? CreatedDate { get; set; }
        /// <summary>
        /// Gets or sets created by.
        /// </summary>
        public int CreatedBy { get; set; }
       
        /// <summary>
        /// Gets or sets the encounter type.
        /// </summary>
        public Library.Enums.OBEncounterType Type { get; set; }
        /// <summary>
        /// Gets or sets the encounter type.
        /// </summary>
        public Library.Enums.GynEncounterType GynEncounterType { get; set; }
        /// <summary>
        /// Gets or sets the json string.
        /// </summary>
        public string JsonString { get; set; }
        /// <summary>
        /// Gets or sets the surgeries.
        /// </summary>
        public string Surgeries { get; set; }
        /// <summary>
        /// Gets or sets the routing value.
        /// </summary>
        public string routingValue { get; set; }
        // <summary>
        /// Gets or sets the routing value.
        /// </summary>
        public string AncCard { get; set; }
        // <summary>
        /// Gets or sets the routing value.
        /// </summary>
        public string GPLA { get; set; }
        
        /// <summary>
        /// Gets or sets the isadmission.
        /// </summary>
        public bool IsAdmission { get; set; }


    }
}
