﻿namespace Hims.Shared.UserModels.DiscountManagement
{
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// The discount module model.
    /// </summary>
    public class DiscountModuleModel
    {
        /// <summary>
        /// Gets or sets the discount module id.
        /// </summary>
        public int DiscountModuleId { get; set; }

        /// <summary>
        /// Gets or sets the module name.
        /// </summary>
        public string ModuleName { get; set; }

        /// <summary>
        /// Gets or sets the icon.
        /// </summary>
        public string Icon { get; set; }

        /// <summary>
        /// Gets or sets the role discounts.
        /// </summary>
        public List<DiscountsPerModuleModel> RoleDiscounts { get; set; }

        /// <summary>
        /// Gets or sets the roles.
        /// </summary>
        public string Roles { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>       
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>       
        public int ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the created by role.
        /// </summary>
        public string CreatedByRole { get; set; }

        /// <summary>
        /// Gets or sets the modified by name.
        /// </summary>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified by role.
        /// </summary>
        public string ModifiedByRole { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public bool? Active { get; set; }
    }
}
