﻿#nullable enable
namespace Hims.Shared.UserModels.Filters
{
    using Hims.Shared.Library.Enums;

    /// <summary>
    /// The dental encounter filter model.
    /// </summary>
    public class DentalEncounterFilterModel
    {
        /// <summary>
        /// Gets or sets the dental encounter id.
        /// </summary>
        public int DentalEncounterId { get; set; }

        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the encrypted encounter id.
        /// </summary>
        public string? EncryptedDentalEncounterId { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the encrypted appointment id.
        /// </summary>
        public string? EncryptedAppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the encrypted appointment id.
        /// </summary>
        public string? EncryptedPatientId { get; set; }

        /// <summary>
        /// Gets or sets the encrypted provider id.
        /// </summary>
        public string? EncryptedProviderId { get; set; }

        /// <summary>
        /// Gets or sets the type.
        /// </summary>
        public DentalEncounterType Type { get; set; }
    }
}
