﻿namespace Hims.Shared.UserModels.Inventory
{
    using System;

    /// <summary>
    /// The inventory bill detail model.
    /// </summary>
    public class InventoryBillDetailModel
    {
        /// <summary>
        /// Gets or sets the inventory purchase detail identifier.
        /// </summary>
        /// <value>
        /// The inventory purchase detail identifier.
        /// </value>
        public int InventoryPurchaseDetailId { get; set; }

        /// <summary>
        /// Gets or sets the inventory purchase header identifier.
        /// </summary>
        /// <value>
        /// The inventory purchase header identifier.
        /// </value>
        public int InventoryPurchaseHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the inventory product identifier.
        /// </summary>
        /// <value>
        /// The inventory product identifier.
        /// </value>
        public int InventoryProductId { get; set; }

        /// <summary>
        /// Gets or sets the tax identifier.
        /// </summary>
        /// <value>
        /// The tax identifier.
        /// </value>
        public int TaxId { get; set; }

        /// <summary>
        /// Gets or sets the quantity.
        /// </summary>
        /// <value>
        /// The quantity.
        /// </value>
        public int Quantity { get; set; }

        /// <summary>
        /// Gets or sets the free.
        /// </summary>
        /// <value>
        /// The free.
        /// </value>
        public int? Free { get; set; }

        /// <summary>
        /// Gets or sets the tax per item.
        /// </summary>
        /// <value>
        /// The tax per item.
        /// </value>
        public int TaxPerItem { get; set; }

        /// <summary>
        /// Gets or sets the discount per item.
        /// </summary>
        /// <value>
        /// The discount per item.
        /// </value>
        public int DiscountPerItem { get; set; } = 0;

        /// <summary>
        /// Gets or sets the purchase rate.
        /// </summary>
        /// <value>
        /// The purchase rate.
        /// </value>
        public double PurchaseRate { get; set; }
               
        /// <summary>
        /// Gets or sets the total.
        /// </summary>
        /// <value>
        /// The total.
        /// </value>
        public double Total { get; set; }

        /// <summary>
        /// Gets or sets the tax amount.
        /// </summary>
        /// <value>
        /// The tax amount.
        /// </value>
        public double TaxAmount { get; set; }

        /// <summary>
        /// Gets or sets the discount amount.
        /// </summary>
        /// <value>
        /// The discount amount.
        /// </value>
        public double DiscountAmount { get; set; }

        /// <summary>
        /// Gets or sets the net amount.
        /// </summary>
        /// <value>
        /// The net amount.
        /// </value>
        public double NetAmount { get; set; }

        /// <summary>
        /// Gets or sets the batch number.
        /// </summary>
        /// <value>
        /// The batch number.
        /// </value>
        public string BatchNumber { get; set; }

        /// <summary>
        /// Gets or sets the name of the category.
        /// </summary>
        /// <value>
        /// The name of the category.
        /// </value>
        public string CategoryName { get; set; }

        /// <summary>
        /// Gets or sets the name of the product.
        /// </summary>
        /// <value>
        /// The name of the product.
        /// </value>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the name of the company.
        /// </summary>
        /// <value>
        /// The name of the company.
        /// </value>
        public string CompanyName { get; set; }
       
        /// <summary>
        /// Gets or sets the tax percentage.
        /// </summary>
        /// <value>
        /// The tax percentage.
        /// </value>
        public string TaxPercentage { get; set; }

        /// <summary>
        /// Gets or sets the expiry date.
        /// </summary>
        /// <value>
        /// The expiry date.
        /// </value>
        public DateTime? ExpiryDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is expiry.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is expiry; otherwise, <c>false</c>.
        /// </value>
        public bool IsExpiry { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is batch number.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is batch number; otherwise, <c>false</c>.
        /// </value>
        public bool IsBatchNumber { get; set; }
    }
}
