﻿namespace Hims.Shared.UserModels
{
    using System;

    /// <summary>
    /// The inventory purchase return model.
    /// </summary>
    public class InventoryPurchaseReturnModel
    {
        /// <summary>
        /// Gets or sets the bill number.
        /// </summary>
        public string BillNumber { get; set; }

        /// <summary>
        /// Gets or sets the bill date.
        /// </summary>
        public DateTime BillDate { get; set; }

        /// <summary>
        /// Gets or sets the supplier id.
        /// </summary>
        public int SupplierId { get; set; }

        /// <summary>
        /// Gets or sets the category id.
        /// </summary>
        public int CategoryId { get; set; }

        /// <summary>
        /// Gets or sets the product id.
        /// </summary>
        public int ProductId { get; set; }

        /// <summary>
        /// Gets or sets the tax id.
        /// </summary>
        public int TaxId { get; set; }

        /// <summary>
        /// Gets or sets the quantity.
        /// </summary>
        public int Quantity { get; set; }

        /// <summary>
        /// Gets or sets the inventory stock id.
        /// </summary>
        public int InventoryStockId { get; set; }

        /// <summary>
        /// Gets or sets the total.
        /// </summary>
        public double Total { get; set; }

        /// <summary>
        /// Gets or sets the discount percentage.
        /// </summary>
        public double? DiscountPercentage { get; set; }

        /// <summary>
        /// Gets or sets the discount in rupee.
        /// </summary>
        public double? DiscountInRupee { get; set; }

        /// <summary>
        /// Gets or sets the gst percentage.
        /// </summary>
        public double GstPercentage { get; set; }

        /// <summary>
        /// Gets or sets the gst in rupee.
        /// </summary>
        public double GstInRupee { get; set; }

        /// <summary>
        /// Gets or sets the net amount.
        /// </summary>
        public double NetAmount { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the role id .
        /// </summary>
        public int RoleId { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string CreatedByName { get; set; }
    }
}
