﻿using System;

namespace Hims.Shared.UserModels.NurseShift
{
    /// <summary>
    /// The basic bed Nurse Shift Map.
    /// </summary>
    public class BedModel
    {
        /// <summary>
        /// Gets or sets the bed identifier.
        /// </summary>
        /// <value>
        /// The bed identifier.
        /// </value>
        public int BedId { get; set; }

        /// <summary>
        /// Gets or sets the name of the bed.
        /// </summary>
        /// <value>
        /// The name of the bed.
        /// </value>
        public string BedName { get; set; }

        /// <summary>
        /// Gets or sets the bed status identifier.
        /// </summary>
        /// <value>
        /// The bed status identifier.
        /// </value>
        public int BedStatusId { get; set; }

        /// <summary>
        /// Gets or sets the name of the bed status.
        /// </summary>
        /// <value>
        /// The name of the bed status.
        /// </value>
        public string BedStatusName { get; set; }

        /// <summary>
        /// Gets or sets the name of the room.
        /// </summary>
        /// <value>
        /// The name of the room.
        /// </value>
        public string RoomName { get; set; }

        /// <summary>
        /// Gets or sets the room rent.
        /// </summary>
        /// <value>
        /// The room rent.
        /// </value>
        public int RoomRent { get; set; }

        /// <summary>
        /// Gets or sets the name of the ward.
        /// </summary>
        /// <value>
        /// The name of the ward.
        /// </value>
        public string WardName { get; set; }

        /// <summary>
        /// Gets or sets the name of the floor.
        /// </summary>
        /// <value>
        /// The name of the floor.
        /// </value>
        public string FloorName { get; set; }

        /// <summary>
        /// Gets or sets the admission no.
        /// </summary>
        /// <value>
        /// The admission no.
        /// </value>
        public string AdmissionNo { get; set; }

        /// <summary>
        /// Gets or sets the admission date.
        /// </summary>
        /// <value>
        /// The admission date.
        /// </value>
        public DateTime? AdmissionDate { get; set; }

        /// <summary>
        /// Gets or sets the name of the doctor.
        /// </summary>
        /// <value>
        /// The name of the doctor.
        /// </value>
        public string DoctorName { get; set; }

        /// <summary>
        /// Gets or sets the doctor gender.
        /// </summary>
        /// <value>
        /// The doctor gender.
        /// </value>
        public string DoctorGender { get; set; }

        /// <summary>
        /// Gets or sets the doctor age.
        /// </summary>
        /// <value>
        /// The doctor age.
        /// </value>
        public int? DoctorAge { get; set; }

        /// <summary>
        /// Gets or sets the doctor image.
        /// </summary>
        /// <value>
        /// The doctor image.
        /// </value>
        public string DoctorImage { get; set; }

        /// <summary>
        /// Gets or sets the name of the department.
        /// </summary>
        /// <value>
        /// The name of the department.
        /// </value>
        public string DepartmentName { get; set; }

        /// <summary>
        /// Gets or sets the name of the patient.
        /// </summary>
        /// <value>
        /// The name of the patient.
        /// </value>
        public string PatientName { get; set; }

        /// <summary>
        /// Gets or sets the patient age.
        /// </summary>
        /// <value>
        /// The patient age.
        /// </value>
        public int? PatientAge { get; set; }

        /// <summary>
        /// Gets or sets the patient gender.
        /// </summary>
        /// <value>
        /// The patient gender.
        /// </value>
        public string PatientGender { get; set; }

        /// <summary>
        /// Gets or sets the patient marital status.
        /// </summary>
        /// <value>
        /// The patient marital status.
        /// </value>
        public string PatientMaritalStatus { get; set; }

        /// <summary>
        /// Gets or sets the umr no.
        /// </summary>
        /// <value>
        /// The umr no.
        /// </value>
        public string UMRNo { get; set; }

        /// <summary>
        /// Gets or sets the patient image.
        /// </summary>
        /// <value>
        /// The patient image.
        /// </value>
        public string PatientImage { get; set; }

        /// <summary>
        /// Gets or sets the nurse image.
        /// </summary>
        /// <value>
        /// The nurse image.
        /// </value>
        public string NurseImage { get; set; }

        /// <summary>
        /// Gets or sets the nurse account identifier.
        /// </summary>
        /// <value>
        /// The nurse account identifier.
        /// </value>
        public int? NurseAccountId { get; set; }

        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        /// <value>
        /// The full name.
        /// </value>
        public string FullName { get; set; }

        /// <summary>
        /// Gets or sets the name of the role.
        /// </summary>
        /// <value>
        /// The name of the role.
        /// </value>
        public string RoleName { get; set; }
        /// <summary>
        /// Gets or sets the nurse shift map identifier.
        /// </summary>
        /// <value>
        /// The nurse shift map identifier.
        /// </value>
        public int? NurseShiftMapId { get; set; }
        /// <summary>
        /// Converts to date.
        /// </summary>
        /// <value>
        /// To date.
        /// </value>
        public DateTime? ToDate { get; set; }

        /// <summary>
        /// Gets or sets from date.
        /// </summary>
        /// <value>
        /// From date.
        /// </value>
        public DateTime? FromDate { get; set; }

        /// <summary>
        /// Gets or sets the name of the priority.
        /// </summary>
        /// <value>
        /// The name of the priority.
        /// </value>
        public string PriorityName { get; set; }

        /// <summary>
        /// Gets or sets the priority icon.
        /// </summary>
        /// <value>
        /// The priority icon.
        /// </value>
        public string PriorityIcon { get; set; }

        /// <summary>
        /// Gets or sets the color of the priority.
        /// </summary>
        /// <value>
        /// The color of the priority.
        /// </value>
        public string PriorityColor { get; set; }
    }
}