﻿namespace Hims.Shared.UserModels.Pharmacy
{
    using System;

    /// <summary>
    /// The retail pharmacy model.
    /// </summary>
    public class RetailPharmacyModel
    {
        /// <summary>
        /// Gets or sets the retail pharmacy id.
        /// </summary>
        public int? RetailPharmacyId { get; set; }

        /// <summary>
        /// Gets or sets the retail name.
        /// </summary>
        public string RetailName { get; set; }

        /// <summary>
        /// Gets or sets the allowed user.
        /// </summary>
        public string AllowedUser { get; set; }

        /// <summary>
        /// Gets or sets the names of the ware house.
        /// </summary>
        /// <value>
        /// The names of the ware house.
        /// </value>
        public string WareHouseNames { get; set; }

        /// <summary>
        /// Gets or sets the user names.
        /// </summary>
        public string UserNames { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy ware house ids.
        /// </summary>
        /// <value>
        /// The pharmacy ware house ids.
        /// </value>
        public string PharmacyWareHouseIds { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy ware house identifier.
        /// </summary>
        /// <value>
        /// The pharmacy ware house identifier.
        /// </value>
        public int? PharmacyWareHouseId { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified by name.
        /// </summary>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the user based store.
        /// </summary>
        public int? UserBasedStore { get; set; }

        /// <summary>
        /// Gets or sets list of Account Id for allowed user .
        /// </summary>
        /// <value>
        /// The provider id (multiple).
        /// </value>
        public string AllowedAccountId { get; set; }

        /// <summary>
        /// Gets or sets the retail ware house link identifier ids.
        /// </summary>
        /// <value>
        /// The retail ware house link identifier ids.
        /// </value>
        public string RetailWareHouseLinkIdIds { get; set; }

        /// <summary>
        /// Gets or sets Active.
        /// </summary>
        public bool? Active { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the login role identifier.
        /// </summary>
        /// <value>
        /// The login role identifier.
        /// </value>
        public int LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets the login role identifier.
        /// </summary>
        /// <value>
        /// The login role identifier.
        /// </value>
        public int? LoginAccountId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is uploded.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is uploded; otherwise, <c>false</c>.
        /// </value>
        public bool IsUploaded { get; set; }

        /// <summary>
        /// Gets or sets the retail pharmacy ids.
        /// </summary>
        /// <value>
        /// The retail pharmacy ids.
        /// </value>
        public string RetailPharmacyIds { get; set; }

        /// <summary>
        /// Gets or sets the name of the location.
        /// </summary>
        /// <value>
        /// The name of the location.
        /// </value>
        public string LocationName { get; set; }
    }
}
