﻿namespace Hims.Shared.UserModels
{
    using System;
    using System.Collections.Generic;
    using System.Diagnostics.CodeAnalysis;

    /// <summary>
    /// The provider shift model.
    /// </summary>
    public class PharmacyStockInfoModel
    {
        /// <summary>
        /// Gets or sets the day.
        /// </summary>
        public int PharmacyStockInfoId { get; set; }

        /// <summary>
        /// Gets or sets the consultation charges.
        /// </summary>
        public int PharmacyProductId { get; set; }


        /// <summary>
        /// Gets or sets the telemedicine charges.
        /// </summary>
        public int PharmacyVatTaxId { get; set; }

        /// <summary>
        /// Gets or sets the consultation Fallow Up charges.
        /// </summary>
        public int QuantityIn { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine Fallow Up charges.
        /// </summary>
        public int QuantityOut { get; set; }


        /// <summary>
        /// Gets or sets the telemedicine Fallow Up charges.
        /// </summary>
        public int StocksAvailable { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine Fallow Up charges.
        /// </summary>
        public string BatchNo { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine Fallow Up charges.
        /// </summary>
        public DateTime ExpiryDate { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine Fallow Up charges.
        /// </summary>
        public int Tc { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine Fallow Up charges.
        /// </summary>
        public double PurchaseRate { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine Fallow Up charges.
        /// </summary>
        public double Mrp { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine Fallow Up charges.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine Fallow Up charges.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine Fallow Up charges.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine Fallow Up charges.
        /// </summary>
        public string Barcode { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine Fallow Up charges.
        /// </summary>
        public string MrpChangeReason { get; set; }

    }

    
}
