﻿namespace Hims.Shared.UserModels
{
    using System;

    /// <summary>
    /// The pharmacy stock model.
    /// </summary>
    public class PharmacyStockModel
    {
        /// <summary>
        /// Gets or sets the pharmacy stock id.
        /// </summary>
        public int PharmacyStockId { get; set; }

        /// <summary>
        /// Gets or sets the encrypted pharmacy stock id.
        /// </summary>
        public string EncryptedPharmacyStockId { get; set; }

        /// <summary>
        /// Gets or sets the term.
        /// </summary>
        /// <value>
        /// The term.
        /// </value>
        public string Term { get; set; }

        /// <summary>
        /// Gets or sets the name of the company.
        /// </summary>
        /// <value>
        /// The name of the company.
        /// </value>
        public string CompanyName { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy retail stock id.
        /// </summary>
        public int PharmacyRetailStockId { get; set; }

        /// <summary>
        /// Gets or sets the operation stock identifier.
        /// </summary>
        /// <value>
        /// The operation stock identifier.
        /// </value>
        public int? OperationStockId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy ot stock id.
        /// </summary>
        public int OTStockId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product id.
        /// </summary>
        public int? PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the tax id.
        /// </summary>
        public int TaxId { get; set; }

        /// <summary>
        /// Gets or sets the quantity in.
        /// </summary>
        public int QuantityIn { get; set; }

        /// <summary>
        /// Gets or sets the quantity out.
        /// </summary>
        public int QuantityOut { get; set; }

        /// <summary>
        /// Gets or sets the available quantity.
        /// </summary>
        public int AvailableQuantity { get; set; }

        /// <summary>
        /// Gets or sets the batch number.
        /// </summary>
        public string BatchNumber { get; set; }

        /// <summary>
        /// Gets or sets the barcode.
        /// </summary>
        public string Barcode { get; set; }

        /// <summary>
        /// Gets or sets the tax percentage.
        /// </summary>
        public string TaxPercentage { get; set; }

        /// <summary>
        /// Gets or sets the expiry date.
        /// </summary>
        public DateTime? ExpiryDate { get; set; }

        /// <summary>
        /// Gets or sets the purchase rate.
        /// </summary>
        public double PurchaseRate { get; set; }

        /// <summary>
        /// Gets or sets the mrp.
        /// </summary>
        public double Mrp { get; set; }

        /// <summary>
        /// Gets or sets the mrp change reason.
        /// </summary>
        public string MrpChangeReason { get; set; }

        /// <summary>
        /// Gets or sets the category name.
        /// </summary>
        public string CategoryName { get; set; }

        /// <summary>
        /// Gets or sets the product name.
        /// </summary>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the generic name.
        /// </summary>
        public string GenericName { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int? PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int? PageSize { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the unavailable stock;
        /// </summary>
        public string UnavailableStock { get; set; }

        /// <summary>
        /// Gets or sets the current mrp availability.
        /// </summary>
        public double CurrentMrpAvailability { get; set; }

        /// <summary>
        /// Gets or sets the current purchase availability.
        /// </summary>
        public double CurrentPurchaseAvailability { get; set; }

        /// <summary>
        /// Gets or sets the retail pharmacy .
        /// </summary>
        public int? RetailPharmacyId { get; set; }

        /// <summary>
        /// Gets or sets filter variable isExpiryProduct .
        /// </summary>
        public bool? IsExpiryProduct { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy ware house identifier.
        /// </summary>
        /// <value>
        /// The pharmacy ware house identifier.
        /// </value>
        public int? PharmacyWareHouseId { get; set; }

        /// <summary>
        /// Gets or sets the ware house ids.
        /// </summary>
        /// <value>
        /// The ware house ids.
        /// </value>
        public string WareHouseIds { get; set; }

        /// <summary>
        /// Gets or sets the bill number.
        /// </summary>
        /// <value>
        /// The bill number.
        /// </value>
        public string BillNumber { get; set; }

        /// <summary>
        /// Gets or sets the name of the wareHouse.
        /// </summary>
        /// <value>
        /// The name of the company.
        /// </value>
        public string WareHouseName { get; set; }

        /// <summary>
        /// Gets or sets the name of the Retail Store .
        /// </summary>
        /// <value>
        /// The name of the company.
        /// </value>
        public string RetailName { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the name of the location.
        /// </summary>
        /// <value>
        /// The name of the location.
        /// </value>
        public string LocationName { get; set; }

        /// <summary>
        /// Gets or sets the name of the rack.
        /// </summary>
        /// <value>
        /// The name of the rack.
        /// </value>
        public string RackName { get; set; }

        /// <summary>
        /// Gets or sets the roq.
        /// </summary>
        /// <value>
        /// The roq.
        /// </value>
        public int? ROQ { get; set; }

        /// <summary>
        /// Gets or sets the rol.
        /// </summary>
        /// <value>
        /// The rol.
        /// </value>
        public int? ROL { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product detail identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product detail identifier.
        /// </value>
        public int? PharmacyProductDetailId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy retail stock ids.
        /// </summary>
        /// <value>
        /// The pharmacy retail stock ids.
        /// </value>
        public string PharmacyRetailStockIds { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is igst.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is igst; otherwise, <c>false</c>.
        /// </value>
        public bool IsIGST { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is SGST.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is SGST; otherwise, <c>false</c>.
        /// </value>
        public bool IsSGST { get; set; }
        /// <summary>
        /// Gets or sets a value indicating whether this instance is CategoryId.
        /// </summary>
        /// <value>      
        /// </value>
        public int? CategoryId { get; set; }
        
    }
}
