﻿namespace Hims.Shared.UserModels.ProgressReport.Labs
{
    using System;
    using static Timeline.Enums;

    /// <summary>
    /// The view model
    /// </summary>
    public class ViewModel
    {
        /// <summary>
        /// Gets or sets the lab booking detail identifier.
        /// </summary>
        /// <value>
        /// The lab booking detail identifier.
        /// </value>
        public int LabBookingDetailId { get; set; }

        /// <summary>
        /// Gets or sets the lab booking header identifier.
        /// </summary>
        /// <value>
        /// The lab booking header identifier.
        /// </value>
        public int LabBookingHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        /// <value>
        /// The name.
        /// </value>
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the code.
        /// </summary>
        /// <value>
        /// The code.
        /// </value>
        public string Code { get; set; }

        /// <summary>
        /// Gets or sets the cost.
        /// </summary>
        /// <value>
        /// The cost.
        /// </value>
        public double? Cost { get; set; }

        /// <summary>
        /// Gets or sets the identifier.
        /// </summary>
        /// <value>
        /// The identifier.
        /// </value>
        public int Id { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is report generated.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is report generated; otherwise, <c>false</c>.
        /// </value>
        public bool IsReportGenerated { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is sample collected.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is sample collected; otherwise, <c>false</c>.
        /// </value>
        public bool IsSampleCollected { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is parameter added.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is parameter added; otherwise, <c>false</c>.
        /// </value>
        public bool IsParameterAdded { get; set; }

        /// <summary>
        /// Gets or sets the verified by.
        /// </summary>
        /// <value>
        /// The verified by.
        /// </value>
        public int? VerifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the name of the verified by.
        /// </summary>
        /// <value>
        /// The name of the verified by.
        /// </value>
        public string VerifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the date.
        /// </summary>
        /// <value>
        /// The date.
        /// </value>
        public DateTime Date { get; set; }

        /// <summary>
        /// Gets or sets the when.
        /// </summary>
        /// <value>
        /// The when.
        /// </value>
        public WhenType? When { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        /// <value>
        /// The status.
        /// </value>
        public LabStatusType? Status { get; set; }

        /// <summary>
        /// Gets or sets the salutation.
        /// </summary>
        /// <value>
        /// The salutation.
        /// </value>
        public string Salutation { get; set; }

        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        /// <value>
        /// The full name.
        /// </value>
        public string FullName { get; set; }

        /// <summary>
        /// Gets or sets the age.
        /// </summary>
        /// <value>
        /// The age.
        /// </value>
        public int Age { get; set; }

        /// <summary>
        /// Gets or sets the gender.
        /// </summary>
        /// <value>
        /// The gender.
        /// </value>
        public string Gender { get; set; }

        /// <summary>
        /// Gets or sets the umr no.
        /// </summary>
        /// <value>
        /// The umr no.
        /// </value>
        public string UMRNo { get; set; }

        /// <summary>
        /// Gets or sets the patient image.
        /// </summary>
        /// <value>
        /// The patient image.
        /// </value>
        public string PatientImage { get; set; }

        /// <summary>
        /// Gets or sets the notes.
        /// </summary>
        /// <value>
        /// The umr no.
        /// </value>
        public string Notes { get; set; }

    }
}
