﻿
namespace Hims.Shared.UserModels.ProviderAvailability
{

    using System.Collections.Generic;
    /// <summary>
    /// The coupon.
    /// </summary>
    public class ModifyAvailabilityModel
    {
        /// <summary>
        /// Gets or sets the admission id.
        /// </summary>
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets the expiry.
        /// </summary>
        /// <value>
        /// The date.
        /// </value>
        public string? FullName { get; set; }

        /// <summary>
        /// Gets or sets the slot tat.
        /// </summary>
        public string? SlotTat { get; set; }

        /// <summary>
        /// Gets or sets the slot duration.
        /// </summary>
        public int? SlotDuration { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public bool? AppointmentStatus { get; set; }

        /// <summary>
        /// Gets or sets the availability.
        /// </summary>
        public string? Availability { get; set; }

        /// <summary>
        /// Gets or sets the available days.
        /// </summary>
        public string? AvailableDays { get; set; }

        /// <summary>
        /// Gets or sets the charges.
        /// </summary>
        public List<ProviderAvailabilityCharges> Charges { get; set; }

        /// <summary>
        /// Gets or sets the consultationId.
        /// </summary>
        public int? ConsultationTypeId { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string? CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the Duration
        /// </summary>
        public List<ProviderAvailabilityDuration> Duration { get; set; }

        /// <summary>
        /// Gets or sets the from date.
        /// </summary>
        public string? FromDate { get; set; }

        /// <summary>
        /// Gets or sets the start date.
        /// </summary>
        public string? LeaveFromDate { get; set; }

        /// <summary>
        /// Gets or sets the end date.
        /// </summary>
        public string? LeaveToDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool IsLeave { get; set; }

        /// <summary>
        /// Gets or sets the login role id.
        /// </summary>
        public int? LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the on checked all day.
        /// </summary>
        public bool OnCheckedAllDay { get; set; }

        /// <summary>
        /// Gets or sets the provider availability id.
        /// </summary>
        public int? ProviderAvailabilityId { get; set; }

        /// <summary>
        /// Gets or sets the slot timings
        /// </summary>
        public List<ProviderAvailabilitySlotsModel> SlotTimings { get; set; }

        /// <summary>
        /// Gets or sets the slots.
        /// </summary>
        public string? Slots { get; set; }

        /// <summary>
        /// Gets or sets the to date.
        /// </summary>
        public string? ToDate { get; set; }


        /// <summary>
        /// Getes or sets the doctorweekId.
        /// </summary>
        public int? DoctorWeekId { get; set; }
    }
    /// <summary>
    /// The duration.
    /// </summary>
    public class ProviderAvailabilityDuration
    {
        /// <summary>
        /// Gets or sets the type id.
        /// </summary>
        public int? Id { get; set; }

        /// <summary>
        /// Gets or sets the value.
        /// </summary>
        public int? Value { get; set; }

        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        public string? Name { get; set; }
    }

    /// <summary>
    /// The duration.
    /// </summary>
    public class ProviderAvailabilityCharges
    {
        /// <summary>
        /// Gets or sets the type id.
        /// </summary>
        public int? Id { get; set; }

        /// <summary>
        /// Gets or sets the value.
        /// </summary>
        public int? Value { get; set; }

        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        public string? Name { get; set; }
    }

    /// <summary>
    /// Gets or sets the provider availability slots model.
    /// </summary>
    public class ProviderAvailabilitySlotsModel
    {

        /// <summary>
        /// Gets or sets the admission id.
        /// </summary>
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the provider availability id.
        /// </summary>
        public int ProviderAvailabilityId { get; set; }

        /// <summary>
        /// Gets or sets the consultationId.
        /// </summary>
        public int? ConsultationTypeId { get; set; }

        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets the location name.
        /// </summary>
        public string LocationName { get; set; }

        /// <summary>
        /// Gets or sets the slot timings
        /// </summary>
        public List<SlotTimingsLocationWise> SlotTimingsLocationWise { get; set; }

        /// <summary>
        /// Gets or sets the slot timings
        /// </summary>
        public List<BreakTimingsLocationWise> SlotBreaksLocationWise { get; set; }

        /// <summary>
        /// Gets or sets the from time.
        /// </summary>
        public string FromTime { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the to time.
        /// </summary>
        public string ToTime { get; set; } = string.Empty;

        ///// <summary>
        ///// Gets or sets the followup days
        ///// </summary>
        //public int? FollowUpDays { get; set; }

        ///// <summary>
        ///// Gets or sets the follow up days limit.
        ///// </summary>
        //public int? FollowUpDaysLimit { get; set; }

        ///// <summary>
        ///// Gets or sets the specializations.
        ///// </summary>
        //public List<int> SpecializationIds { get; set; }

        /// <summary>
        /// Gets or sets the specializations.
        /// </summary>
        public int? SpecializationIds { get; set; }

        /// <summary>
        /// Gets or sets the no of new patient.
        /// </summary>
        public int? NoOfNewPatient { get; set; }

        /// <summary>
        /// Gets or sets the no of new patient.
        /// </summary>
        public int? NoOfOfflinePatient { get; set; }

    }


    /// <summary>
    /// Gets or sets the slot timings location wise model.
    /// </summary>
    public class SlotTimingsLocationWise

    {

        /// <summary>
        /// Gets or sets the consultationId.
        /// </summary>
        public int? ConsultationTypeId { get; set; }

        /// <summary>
        /// Gets or sets the from time.
        /// </summary>
        public string FromTime { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the general slots.
        /// </summary>
        public int GeneralSlots { get; set; }

        /// <summary>
        /// Gets or sets the no of new patient.
        /// </summary>
        public int? NoOfNewPatient { get; set; }

        /// <summary>
        /// Gets or sets the no of new patient.
        /// </summary>
        public int NoOfNewPatientSlots{ get; set; }

        /// <summary>
        /// Gets or sets the no of new patient.
        /// </summary>
        public int? NoOfOfflinePatient { get; set; }

        /// <summary>
        /// Gets or sets the no of new patient.
        /// </summary>
        public int? NoOfOfflinePatientSlots { get; set; }

        /// <summary>
        /// Gets or sets the provider availability id.
        /// </summary>
        public int ProviderAvailabilityId { get; set; }

        /// <summary>
        /// Gets or sets the specializations.
        /// </summary>
        public int? SpecializationDuration { get; set; }

        /// <summary>
        /// Gets or sets the specializations.
        /// </summary>
        public int? SpecializationIds { get; set; }

        /// <summary>
        /// Gets or sets the to time.
        /// </summary>
        public string ToTime { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the provider availability id.
        /// </summary>
        public int TotalSlots { get; set; }

    }

    /// <summary>
    /// Gets or sets the slot timings location wise model.
    /// </summary>
    public class BreakTimingsLocationWise

    {
        /// <summary>
        /// Gets or sets the break from time.
        /// </summary>
        public string BreakFromTime { get; set; }

        /// <summary>
        /// Gets or sets the break to time.
        /// </summary>
        public string BreakToTime { get; set; }

        /// <summary>
        /// Gets or sets the break specialization id.
        /// </summary>
        public int? BreakSpecializationId { get; set; }

        /// <summary>
        /// Gets or sets break consultation type id.
        /// </summary>
        public int? BreakConsultationTypeId { get; set; }

        /// <summary>
        /// Gets or sets the Break Provider Availability Id.
        /// </summary>
        public int? ProviderBreakId { get; set;}

        /// <summary>
        /// Gets or sets the Break Type.
        /// </summary>
        public string? BreakType { get; set; }

        /// <summary>
        /// Gets or sets the Break Block.
        /// </summary>
        public string? BreakBlock { get; set; }
    }

}

