﻿#nullable enable
namespace Hims.Shared.UserModels
{
    using System;

    /// <summary>
    /// The provider availability model.
    /// </summary>
    public class ProviderDurationModel
    {
        /// <summary>
        /// Gets or sets the provider availability id.
        /// </summary>
        public int ProviderAvailabilityId { get; set; }

        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the provider location id.
        /// </summary>
        public int ProviderLocationId { get; set; }

        /// <summary>
        /// Gets or sets the provider location name.
        /// </summary>
        public string ProviderLocationName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the practice location name.
        /// </summary>
        public string PracticeLocationName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the practice name.
        /// </summary>
        public string PracticeName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the practice tin.
        /// </summary>
        public string PracticeTIN { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the date.
        /// </summary>
        public DateTime Date { get; set; }

        /// <summary>
        /// Gets or sets the day name.
        /// </summary>
        public string DayName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the day no.
        /// </summary>
        public int DateNumber { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public char? Status { get; set; }

        /// <summary>
        /// Gets or sets the from time.
        /// </summary>
        public string? From24HrsTime { get; set; }

        /// <summary>
        /// Gets or sets the to time.
        /// </summary>
        public string? To24HrsTime { get; set; }

        /// <summary>
        /// Gets or sets the from time.
        /// </summary>
        public string? From12HrsTime { get; set; }

        /// <summary>
        /// Gets or sets the to time.
        /// </summary>
        public string? To12HrsTime { get; set; }
    }
}