﻿namespace Hims.Shared.UserModels.Vendors
{
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// The vendor purchase product list.
    /// </summary>
    public class VendorPurchaseProductList
    {
        /// <summary>
        /// Gets or sets the pharmacy product identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product identifier.
        /// </value>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the supplier product header identifier.
        /// </summary>
        /// <value>
        /// The supplier product header identifier.
        /// </value>
        public int SupplierProductHeaderId { get; set; }
        /// <summary>
        /// Gets or sets the supplier product detail identifier.
        /// </summary>
        /// <value>
        /// The supplier product detail identifier.
        /// </value>
        public int SupplierProductDetailId { get; set; }

        /// <summary>
        /// Gets or sets the purchase rate.
        /// </summary>
        /// <value>
        /// The purchase rate.
        /// </value>
        public double? PurchaseRate { get; set; }

        /// <summary>
        /// Gets or sets the MRP.
        /// </summary>
        /// <value>
        /// The MRP.
        /// </value>
        public double? Mrp { get; set; }

        /// <summary>
        /// Gets or sets the tax per item.
        /// </summary>
        /// <value>
        /// The tax per item.
        /// </value>
        public int TaxPerItem { get; set; }

        /// <summary>
        /// Gets or sets the bill date.
        /// </summary>
        /// <value>
        /// The bill date.
        /// </value>
        public DateTime? BillDate { get; set; }

        /// <summary>
        /// Gets or sets the name of the supplier.
        /// </summary>
        /// <value>
        /// The name of the supplier.
        /// </value>
        public string SupplierName { get; set; }

        /// <summary>
        /// Gets or sets the deliver days.
        /// </summary>
        /// <value>
        /// The deliver days.
        /// </value>
        public int? DeliverDays { get; set; }

        /// <summary>
        /// Gets or sets the name of the product.
        /// </summary>
        /// <value>
        /// The name of the product.
        /// </value>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the name of the generic.
        /// </summary>
        /// <value>
        /// The name of the generic.
        /// </value>
        public string GenericName { get; set; }

        /// <summary>
        /// Gets or sets the name of the sale unit.
        /// </summary>
        /// <value>
        /// The name of the sale unit.
        /// </value>
        public string SaleUnitName { get; set; }

        /// <summary>
        /// Gets or sets the name of the purchase unit.
        /// </summary>
        /// <value>
        /// The name of the purchase unit.
        /// </value>
        public string PurchaseUnitName { get; set; }

        /// <summary>
        /// Gets or sets the sale unit qty.
        /// </summary>
        /// <value>
        /// The sale unit qty.
        /// </value>
        public int SaleUnitQty { get; set; }

        /// <summary>
        /// Gets or sets the purchase unit qty.
        /// </summary>
        /// <value>
        /// The purchase unit qty.
        /// </value>
        public int PurchaseUnitQty { get; set; }

        /// <summary>
        /// Gets or sets the supplier identifier.
        /// </summary>
        /// <value>
        /// The supplier identifier.
        /// </value>
        public int? SupplierId { get; set; }

        /// <summary>
        /// Gets or sets the formulations.
        /// </summary>
        /// <value>
        /// The formulations.
        /// </value>
        public List<SupplierProductFormulationModel> Formulations { get; set; }
    }

    /// <summary>
    /// The vendor purchase history.
    /// </summary>
    public class VendorPurchaseHistory
    {
        /// <summary>
        /// Gets or sets from GRN.
        /// </summary>
        /// <value>
        /// From GRN.
        /// </value>
        public List<VendorPurchaseProductList> FromGrn { get; set; }

        /// <summary>
        /// Gets or sets from prefered vendor.
        /// </summary>
        /// <value>
        /// From prefered vendor.
        /// </value>
        public List<VendorPurchaseProductList> FromPreferedVendor { get; set; }
    }
}
