﻿namespace Hims.Shared.UserModels.WebNotification
{
    using System;

    /// <summary>
    /// The web notification filter model.
    /// </summary>
    public class WebNotificationFilterModel
    {

        /// <summary>
        /// Gets or sets the role identifier.
        /// </summary>
        /// <value>
        /// The role identifier.
        /// </value>
        public int RoleId { get; set; }

        /// <summary>
        /// Gets or sets the size of the page.
        /// </summary>
        /// <value>
        /// The size of the page.
        /// </value>
        public int? PageSize { get; set; }

        /// <summary>
        /// Gets or sets the index of the page.
        /// </summary>
        /// <value>
        /// The index of the page.
        /// </value>
        public int? PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the patient identifier.
        /// </summary>
        /// <value>
        /// The patient identifier.
        /// </value>
        public int? PatientId { get; set; }

        /// <summary>
        /// Gets or sets the provider identifier.
        /// </summary>
        /// <value>
        /// The provider identifier.
        /// </value>
        public int? ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the web notification type id.
        /// </summary>
        /// <value>
        /// The web notification type id.
        /// </value>
        public int? WebNotificationTypeId { get; set; }

        /// <summary>
        /// Gets or sets from time.
        /// </summary>
        /// <value>
        /// From time.
        /// </value>
        public DateTime? FromDate { get; set; }

        /// <summary>
        /// Converts to time.
        /// </summary>
        /// <value>
        /// To time.
        /// </value>
        public DateTime? ToDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether [show read].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [show read]; otherwise, <c>false</c>.
        /// </value>
        public bool ShowRead { get; set; }

        /// <summary>
        /// module type.
        /// </summary>
        /// <value>
        /// module type.
        /// </value>
        public string ModuleType { get; set; }
        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the filters.
        /// </summary>
        public string? FilterPatient  {get; set;}

        /// <summary>
        /// Gets or sets the provider identifier.
        /// </summary>
        /// <value>
        /// The provider identifier.
        /// </value>
        public int? ScanMachineMasterId { get; set; }


        /// <summary>
        /// Gets or sets the module identifier not to display.
        /// </summary>
        /// <value>
        /// The module identifier not to display.
        /// </value>
        public int? ModuleIdNotToDisplay { get; set; }
    }
}
