﻿using Hims.Shared.EntityModels;
using Hims.Shared.UserModels.Counselling;
using System;
using System.Collections.Generic;
using System.Threading.Tasks;

namespace Hims.Domain.Services
{
    public interface ICounsellingService
    {
        Task<IEnumerable<CounsellingBasicModel>> FetchBasicsAsync(PackageTypeModel model);

        Task<IEnumerable<CounsellingModel>> FetchAsync(int patientId);

        Task<CounsellingModel> FindAsync(int counsellingId);

        Task<IEnumerable<CounsellingDetailModel>> FetchDetailsAsync(int counsellingId);

        Task<CounsellingPatientModel> FindPatientInfoAsync(int patientId);

        Task<int> AddAsync(CounsellingModel model, List<CounsellingDetailModel> counsellingDetails);

        Task<int> UpdateAsync(CounsellingModel model, List<CounsellingDetailModel> counsellingDetails);

        Task<int> UpdateSignaturesAsync(int counsellingId, string signaturePath, bool isPatient);

        Task<int> PublishAsync(int counsellingId, int publishedBy);

        Task<int> DisableAsync(int counsellingId, int disabledBy);

        Task<int> EnableAsync(int counsellingId, int enabledBy);

        Task<int> DeleteAsync(int counsellingId);
    }
}