﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.EntityModels;
    using Shared.UserModels.Filters;

    /// <summary>
    /// The Coupon Service interface.
    /// </summary>
    public interface ICouponService
    {
        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<CouponModel>> FetchAsync(CouponFilterModel model);

        /// <summary>
        /// The fetch eligible coupons async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<CouponModel>> FetchEligibleCouponsAsync(CouponFilterModel model);

        /// <summary>
        /// The add async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> AddAsync(CouponModel model);

        /// <summary>
        /// The update async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UpdateAsync(CouponModel model);

        /// <summary>
        /// The get delete async.
        /// </summary>
        /// <param name="couponId">
        /// The coupon id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> DeleteAsync(int couponId);

        /// <summary>
        /// The modify status async.
        /// </summary>
        /// <param name="couponId">
        /// The coupon id.
        /// </param>
        /// <param name="modifiedBy">
        /// The modified By.
        /// </param>
        /// <param name="status">
        /// The status.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> ModifyStatusAsync(int couponId, int modifiedBy, bool status);

        /// <summary>
        /// The apply async.
        /// </summary>
        /// <param name="couponCode">
        /// The coupon code.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<CouponModel> ApplyAsync(string couponCode);

        /// <summary>
        /// The fetch active coupon async.
        /// </summary>
        /// <param name="couponCode">
        /// The coupon code.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<CouponModel> FetchActiveCoupon(string couponCode);

        /// <summary>
        /// Fetch total appointments booked by patient.
        /// </summary>
        /// <param name="patientId">
        /// The Patient Id
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<AppointmentModel>> FetchPatientAppointments(int patientId);
    }
}
