﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Linq;
    using System.Threading.Tasks;
    using Shared.UserModels.DynamicTemplate;
    /// <summary>
    /// The dynamic template Service interface.
    /// </summary>
    public interface IDynamicTemplateService
    {
        /// <summary>
        /// Inserts the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> InsertAsync(InsertModel model);

        /// <summary>
        /// Updates the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> UpdateAsync(InsertModel model);

        /// <summary>
        /// Deletes the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> DeleteAsync(InsertModel model);

        /// <summary>
        /// fetch the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<FetchModel>> FetchAsync(FetchModel model);
    }
}
