﻿using System.Collections.Generic;
using System.Threading.Tasks;
using Hims.Shared.UserModels.MealType;

namespace Hims.Domain.Services
{
    /// <summary>
    /// The Coupon Service interface.
    /// </summary>
    public interface IMealTypesService
    {

        /// <summary>
        /// The add async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> AddAsync(InsertModel model);
        
        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<ViewModel>> FetchAsync(ViewModel model);

        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<ViewModel>> FetchActiveMealTypes(ViewModel model);


        /// <summary>
        /// The add async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UpdateAsync(UpdateModel model);

        /// <summary>
        /// The delete retail store async.
        /// </summary>
        /// <param name="mealTypeId">
        /// The retail pharmacy id.
        /// </param>
        /// <param name="modifiedBy">Index of the page.</param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<int> ModifyMealStatusAsync(UpdateModel model);
    }
}
