﻿using System;
using System.Collections.Generic;
using System.Threading.Tasks;
using Dapper;
using Hims.Domain.Entities;
using Hims.Domain.Repositories.UnitOfWork;
using Hims.Domain.Services;
using Newtonsoft.Json.Linq;
using Hims.Shared.EntityModels;
using Hims.Shared.UserModels.ConsultationType;

namespace Hims.Infrastructure.Services
{
    /// <inheritdoc />
    public class ConsultationTypeService : IConsultationTypeService
    {
        /// <summary>
        /// The unit of work.
        /// </summary>
        private readonly IUnitOfWork unitOfWork;

        /// <inheritdoc cref="IConsultationTypeService" />
        public ConsultationTypeService(IUnitOfWork unitOfWork) => this.unitOfWork = unitOfWork;

        /// <inheritdoc />
        public Task<IEnumerable<ViewModel>> FetchAsync(FilterModel model)
        {
            var where = " WHERE 1 = 1 ";

            if (model.LocationId != null)
            {
                where += $@" AND LAM.""LocationId"" = {model.LocationId}";
            }
            //if (model.ProviderId !=null) {
            //    where += $@" AND P.""ProviderId"" = {model.ProviderId}";
            //}
            if (model.ConsultationTypeId != null)
            {
                where += $@" AND S.""ConsultationTypeId"" = {model.SpecializationId}";
            }
            var query = $@" select * from ""ConsultationType""
                            { where}";

            if (model.PageIndex <= 0)
            {
                return this.unitOfWork.Current.QueryAsync<ViewModel>(query);
            }

            model.PageIndex -= 1;
            query += " LIMIT " + model.PageSize + " offset " + (model.PageIndex * model.PageSize);
            return this.unitOfWork.Current.QueryAsync<ViewModel>(query);
        }


        /// <inheritdoc />
        public async Task<int> AddAsync(InsertModel model)
        {
            try
            {
                //var checkIf = await this.unitOfWork.Current.QueryFirstOrDefaultAsync<int>($@"SELECT COUNT(""VisitTypeId"") FROM ""VisitType"" WHERE TRIM(UPPER(""VisitorName"")) = '{model.VisitorName.ToUpper().Trim()}'");
                //if (checkIf > 0)
                //{
                //    return -1;
                //}
                if (model.ConsultationTypeId == 0)
                {
                    var consultationType = new ConsultationType
                    {
                        Active = true,
                        LocationId = model.LocationId,
                        CreatedBy = model.CreatedBy,
                        CreatedDate = DateTime.Now,
                        Name = model.Name

                    };

                    return await this.unitOfWork.ConsultationType.InsertAsync(consultationType);
                }
                else
                {
                    var checkIf = await this.unitOfWork.ConsultationType.FindAsync(m => m.ConsultationTypeId == model.ConsultationTypeId);
                    
                    checkIf.Active = true;
                    checkIf.LocationId = checkIf.LocationId;
                    checkIf.ModifiedBy = model.CreatedBy;
                    checkIf.ModifiedDate = DateTime.Now;
                    checkIf.Name = model.Name;
                    var updateExecute = await this.unitOfWork.ConsultationType.UpdateAsync(checkIf);
                    return updateExecute;
                }

            }
            catch (Exception e)
            {
                Console.WriteLine(e.Message.ToString());
            }

            return 1;
        }

        /// <inheritdoc />
        public Task<int> DeleteAsync(int consultationTypeId)
        {
            var query = $@"DELETE FROM ""ConsultationType"" WHERE ""ConsultationTypeId""= {consultationTypeId}";
            return this.unitOfWork.Current.ExecuteAsync(query);
        }

        public async Task<string> FindNameByConsultationTypeId(int consultationId)
        {
            var query = $@"SELECT ""Name"" FROM ""ConsultationType"" WHERE ""ConsultationTypeId"" = {consultationId}";
            var response = await this.unitOfWork.Current.QuerySingleOrDefaultAsync<string>(query);
            return response;
        }

    }
}