﻿#nullable enable
namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The auditLog.
    /// </summary>
    public class AuditLogModel
    {
        /// <summary>
        /// Gets or sets the auditLog id.
        /// </summary>
        public int AuditLogId { get; set; }

        /// <summary>
        /// Gets or sets the Log type.
        /// </summary>
        public int LogTypeId { get; set; }

        /// <summary>
        /// Gets or sets the log type name.
        /// </summary>
        public string? LogTypeName { get; set; }

        /// <summary>
        /// Gets or sets the log date.
        /// </summary>
        public DateTime LogDate { get; set; }

        /// <summary>
        /// Gets or sets the app type.
        /// </summary>
        public short LogFrom { get; set; }

        /// <summary>
        /// Gets or sets the account id.
        /// </summary>
        public int? AccountId { get; set; }

        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        public string? FullName { get; set; }
        /// <summary>
        /// Gets or sets the RoleId.
        /// </summary>
        public int? RoleId { get; set; }

        /// <summary>
        /// Gets or sets the role name.
        /// </summary>
        public string? RoleName { get; set; }

        /// <summary>
        /// Gets or sets the auditLog code.
        /// </summary>
        public string LogDescription { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the location id
        /// </summary>
        public int? LocationId { get; set; }
    }
}