﻿namespace Hims.Shared.EntityModels
{
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// The appointment.
    /// </summary>
    public class DashboardWidgetModel
    {
        /// <summary>
        /// Gets or sets the widget id.
        /// </summary>
        public int? DashboardWidgetId { get; set; }

        /// <summary>
        /// Gets or sets the widget name.
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the name of the count type.
        /// </summary>
        /// <value>
        /// The name of the count type.
        /// </value>
        public string CountTypeName { get; set; }

        /// <summary>
        /// Gets or sets the widget type id.
        /// </summary>
        public int DashboardWidgetTypeId { get; set; }

        /// <summary>
        /// Gets or sets the dashboard widget count type identifier.
        /// </summary>
        /// <value>
        /// The dashboard widget count type identifier.
        /// </value>
        public int? DashboardWidgetCountTypeId { get; set; }

        /// <summary>
        /// Gets or sets the widget type.
        /// </summary>
        public string Type { get; set; }

        /// <summary>
        /// Gets or sets the count type identifier.
        /// </summary>
        /// <value>
        /// The count type identifier.
        /// </value>
        public int? CountTypeId { get; set; }

        /// <summary>
        /// Gets or sets the icon.
        /// </summary>
        /// <value>
        /// The icon.
        /// </value>
        public string Icon { get; set; }

        /// <summary>
        /// Gets or sets the stored procedure name.
        /// </summary>
        public string StoredProcedureName { get; set; }

        /// <summary>
        /// Gets or sets the execute sp.
        /// </summary>
        /// <value>
        /// The execute sp.
        /// </value>
        public string ExecSp { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified by name.
        /// </summary>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the Log From.
        /// </summary>
        public short? LogFrom { get; set; }

        /// <summary>
        /// Gets or sets the Total items.
        /// </summary>
        public int? TotalItems { get; set; }

        /// <summary>
        /// gets or sets the roleId.
        /// </summary>
        public List<int> Roles { get; set; }

        /// <summary>
        /// gets or sets the roleId.
        /// </summary>
        public string RolesStr { get; set; }

        /// <summary>
        /// Gets or sets the Location Id.
        /// </summary>
        public int? LocationId { get; set; }
    }
}
