﻿using Hims.Shared.Dapper.Attributes;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace Hims.Shared.EntityModels
{
    public class PackageDocumentModel
    {
        /// <summary>
        /// Gets or sets the patient document id.
        /// </summary>
        [Key, Identity]
        public int PackageDocumentId { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        [IgnoreUpdate]
        public int PackageModuleId { get; set; }

        /// <summary>
        /// Gets or sets the uploaded by id.
        /// </summary>
        [IgnoreUpdate]
        public int UploadedBy { get; set; }

        /// <summary>
        /// Gets or sets the document name.
        /// </summary>
        public string DocumentName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the content type.
        /// </summary>
        public string ContentType { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the size.
        /// </summary>
        public float Size { get; set; }

        /// <summary>
        /// Gets or sets the description.
        /// </summary>
        public string? Description { get; set; }

        /// <summary>
        /// Gets or sets the document url.
        /// </summary>
        public string DocumentUrl { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the thumbnail url.
        /// </summary>
        public string ThumbnailUrl { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the uploaded date.
        /// </summary>
        public DateTime UploadedDate { get; set; }

        /// <summary>
        /// Gets or sets the login role Id.
        /// </summary>
        public int? LoginRoleId { get; set; }
        /// <summary>
        /// Gets or sets the name of creation.
        /// </summary>
        public string CreatedByName{ get; set; }

        /// <summary>
        /// Gets or sets the id of location.
        /// </summary>
        public int? LocationId  { get; set; }

    }
}
