﻿namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The pharmacy indent detail model.
    /// </summary>
    public class PharmacyIndentDetailModel
    {
        /// <summary>
        /// Gets or sets the pharmacy indent header id.
        /// </summary>
        public int PharmacyIndentHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy indent detail id.
        /// </summary>
        public int PharmacyIndentDetailId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy issue header id.
        /// </summary>
        public int? PharmacyIssueHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product id.
        /// </summary>
        public int? PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the quantity.
        /// </summary>
        public int Quantity { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public string Status { get; set; }

        /// <summary>
        /// Gets or sets the product name.
        /// </summary>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the approved quantity. 
        /// </summary>
        public int? ApprovedQuantity { get; set; }

        /// <summary>
        /// Gets or sets the name of the retail.
        /// </summary>
        /// <value>
        /// The name of the retail.
        /// </value>
        public string RetailName { get; set; }
        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string CreatedByName { get; set; }
        /// <summary>
        /// Gets or sets the created date .
        /// </summary>
        public DateTime? CreatedDate { get; set; }


    }
}
