﻿namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The service.
    /// </summary>
    public class ServiceModel
    {
        /// <summary>
        /// Gets or sets the service id.
        /// </summary>
        public int ServiceId { get; set; }

        /// <summary>
        /// Gets or sets the service name.
        /// </summary>
        public string ServiceName { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }
        
        /// <summary>
        /// Gets or sets the created by Name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }
        
        /// <summary>
        /// Gets or sets the Modified by Name.
        /// </summary>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the serviceJson.
        /// </summary>
        public string ServiceJson { get; set; }

        /// <summary>
        /// Gets or sets the serviceIconId.
        /// </summary>
        public int? ServiceIconId { get; set; }

        /// <summary>
        /// Gets or sets the url.
        /// </summary>
        public string Url { get; set; }

        /// <summary>
        /// Gets or sets the url.
        /// </summary>
        public int? Priority { get; set; }
    }
}
