﻿namespace Hims.Shared.Library.Enums
{
    /// <summary>
    /// The dental encounter type.
    /// </summary>
    public enum DentalEncounterType
    {
        /// <summary>
        /// The chief complaints.
        /// </summary>
        ChiefComplaints = 1,

        /// <summary>
        /// The medical history.
        /// </summary>
        MedicalHistory,

        /// <summary>
        /// The dental history.
        /// </summary>
        DentalHistory,

        /// <summary>
        /// The family history.
        /// </summary>
        FamilyHistory,

        /// <summary>
        /// The personal habits.
        /// </summary>
        PersonalHabits,

        /// <summary>
        /// The oral hygiene.
        /// </summary>
        OralHygiene,

        /// <summary>
        /// The clinical findings.
        /// </summary>
        ClinicalFindings,

        /// <summary>
        /// The diagnosis.
        /// </summary>
        Diagnosis,

        /// <summary>
        /// The medications.
        /// </summary>
        Medications,

        /// <summary>
        /// The medication comment.
        /// </summary>
        MedicationComment
    }
}
