﻿namespace Hims.Shared.UserModels.Pharmacy
{
    using System;

    /// <summary>
    /// The pharmacy retail stock model.
    /// </summary>
    public class PharmacyRetailStockModel
    {
        /// <summary>
        /// Gets or sets the pharmacy retail stock id.
        /// </summary>
        public int PharmacyRetailStockId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product id.
        /// </summary>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the tax id.
        /// </summary>
        public int TaxId { get; set; }

        /// <summary>
        /// Gets or sets the quantity in.
        /// </summary>
        public int QuantityIn { get; set; }

        /// <summary>
        /// Gets or sets the quantity out.
        /// </summary>
        public int QuantityOut { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy stock id.
        /// </summary>
        public int? PharmacyStockId { get; set; }

        /// <summary>
        /// Gets or sets the batch number.
        /// </summary>
        public string BatchNumber { get; set; }

        /// <summary>
        /// Gets or sets the barcode.
        /// </summary>
        public string Barcode { get; set; }

        /// <summary>
        /// Gets or sets the expiry date.
        /// </summary>
        public DateTime? ExpiryDate { get; set; }

        /// <summary>
        /// Gets or sets the purchase rate.
        /// </summary>
        public double PurchaseRate { get; set; }

        /// <summary>
        /// Gets or sets the mrp.
        /// </summary>
        public double Mrp { get; set; }
        /// <summary>
        /// Gets or sets the loss amount.
        /// </summary>
        public double LossAmount { get; set; }
        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the update type.
        /// </summary>
        public string UpdateType { get; set; }

        /// <summary>
        /// Gets or sets the login Account value id.
        /// </summary>
        public int? LoginAccountId { get; set; }

        /// <summary>
        /// Gets or sets the login Role value id.
        /// </summary>
        public int? LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets the product name.
        /// </summary>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the retail ware house link identifier.
        /// </summary>
        /// <value>
        /// The retail ware house link identifier.
        /// </value>
        public int? RetailWareHouseLinkId { get; set; }

        public int? LocationId { get; set; }

        public string? ResultsType { get; set;}

        public string? FromDate { get; set; }

        public string? ToDate { get; set; }
    }
}
