﻿namespace Hims.Shared.UserModels.Pharmacy
{
    using System;
    using System.Collections.Generic;
    using System.Text;

    /// <summary>
    /// /The pharmacy sale detail model.
    /// </summary>
    public class PharmacySaleDetailModel
    {
        /// <summary>
        /// Gets or sets the pharmacy sale detail id.
        /// </summary>        
        public int PharmacySaleDetailId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy sale header id.
        /// </summary>
        public int PharmacySaleHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the serial num.
        /// </summary>
        public int SerialNum { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product id.
        /// </summary>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the tax id.
        /// </summary>
        public int TaxId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy retail stock id.
        /// </summary>
        public int PharmacyRetailStockId { get; set; }

        /// <summary>
        /// Gets or sets the quantity.
        /// </summary>
        public int Quantity { get; set; }

        /// <summary>
        /// Gets or sets the return quantity.
        /// </summary>
        public int? ReturnQuantity { get; set; }

        /// <summary>
        /// Gets or sets the total.
        /// </summary>
        public double Total { get; set; }

        /// <summary>
        /// Gets or sets the tax amount.
        /// </summary>
        public double TaxAmount { get; set; }

        /// <summary>
        /// Gets or sets the discount per item.
        /// </summary>
        public double? DiscountPerItem { get; set; }

        /// <summary>
        /// Gets or sets the discount.
        /// </summary>
        public double? Discount { get; set; }

        /// <summary>
        /// Gets or sets the net amount.
        /// </summary>
        public double NetAmount { get; set; }

        /// <summary>
        /// Gets or sets the MRP.
        /// </summary>
        /// <value>
        /// The MRP.
        /// </value>
        public double Mrp { get; set; }

        /// <summary>
        /// Gets or sets the tax percentage.
        /// </summary>
        /// <value>
        /// The tax percentage.
        /// </value>
        public int TaxPercentage { get; set; }
    }
}
