﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Hims.Shared.UserModels
{
    /// <summary>
    /// The ProviderSpecializationConsultationtype Model.
    /// </summary>
    public class ProviderSpecializationConsultationtypeModel
    {
        /// <summary>
        /// Gets or sets the provider identifier.
        /// </summary>
        /// <value>
        /// The provider identifier.
        /// </value>
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the specialization identifier.
        /// </summary>
        /// <value>
        /// The specialization identifier.
        /// </value>
        public int SpecializationId { get; set; }

        /// <summary>
        /// Gets or sets the consultation type identifier.
        /// </summary>
        /// <value>
        /// The consultation type identifier.
        /// </value>
        public int ConsultationTypeId { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets the name of the doctor.
        /// </summary>
        /// <value>
        /// The name of the doctor.
        /// </value>
        public string DoctorName { get; set; }

        /// <summary>
        /// Gets or sets the name of the specialization.
        /// </summary>
        /// <value>
        /// The name of the specialization.
        /// </value>
        public string SpecializationName { get; set; }

        /// <summary>
        /// Gets or sets the name of the consultation type.
        /// </summary>
        /// <value>
        /// The name of the consultation type.
        /// </value>
        public string ConsultationTypeName { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        /// <value>
        /// The total items.
        /// </value>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the size of the page.
        /// </summary>
        /// <value>
        /// The size of the page.
        /// </value>
        public int? PageSize { get; set; }

        /// <summary>
        /// Gets or sets the index of the page.
        /// </summary>
        /// <value>
        /// The index of the page.
        /// </value>
        public int? PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the term.
        /// </summary>
        /// <value>
        /// The term.
        /// </value>
        public string Term { get; set; }

        /// <summary>
        /// Gets or sets the active.
        /// </summary>
        /// <value>
        /// The active.
        /// </value>
        public bool? Active { get; set; }
    }
}
