﻿namespace Hims.Domain.Helpers
{
    /// <summary>
    /// The AES Factory interface.
    /// </summary>
    public interface IAESHelper
    {
        /// <summary>
        /// The decrypt.
        /// </summary>
        /// <param name="value">
        /// The value.
        /// </param>
        /// <returns>
        /// The <see cref="string"/>.
        /// </returns>
        string Decrypt(string value);

        /// <summary>
        /// The encrypt.
        /// </summary>
        /// <param name="value">
        /// The value.
        /// </param>
        /// <returns>
        /// The <see cref="string"/>.
        /// </returns>
        string Encrypt(string value);

        /// <summary>
        /// The decode.
        /// </summary>
        /// <param name="value">
        /// The value.
        /// </param>
        /// <returns>
        /// The <see cref="string"/>.
        /// </returns>
        string Decode(string value);

        /// <summary>
        /// The encode.
        /// </summary>
        /// <param name="value">
        /// The value.
        /// </param>
        /// <returns>
        /// The <see cref="string"/>.
        /// </returns>
        string Encode(string value);
    }
}