﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.UserModels.ProgressReport.Vitals;
    using MedicationInfo = Shared.UserModels.ProgressReport.MedicationInfo;
    using Labs = Shared.UserModels.ProgressReport.Labs;
    using Resource = Hims.Shared.UserModels.VitalType;

    /// <summary>
    /// The Coupon Service interface.
    /// </summary>
    public interface IProgressReportVitalsService
    {
        /// <summary>
        /// Fetches the note information asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<MedicationInfo.LabFetchModel>> FetchVitalsInfoAsync(Labs.FilterModel model);

        /// <summary>
        /// Fetches the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<ViewModel>> FetchAsync(FilterModel model);

        /// <summary>
        /// Inserts the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> InsertAsync(InsertModel model);

        /// <summary>
        /// Updates the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> UpdateAsync(UpdateModel model);

        /// <summary>
        /// Deletes the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> DeleteAsync(DeleteModel model);

        /// <summary>
        /// Fetches the vital type asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<Resource.ViewModel>> FetchVitalTypeAsync();

        /// <summary>
        /// Fetches the unit type asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<Resource.ViewModel>> FetchUnitTypeAsync();

    }
}
