﻿namespace Hims.Infrastructure.Services
{
    using System;
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Dapper;
    using Domain.Entities;
    using Domain.Repositories.UnitOfWork;
    using Domain.Services;
    using Hims.Shared.Library;
    using Shared.EntityModels;
    using Shared.UserModels.AssessmentType;

    /// <inheritdoc />
    public class AssessmentTypeService : IAssessmentTypeService
    {
        /// <summary>
        /// The unit of work.
        /// </summary>
        private readonly IUnitOfWork unitOfWork;

        /// <inheritdoc cref="IAssessmentTypeService" />
        public AssessmentTypeService(IUnitOfWork unitOfWork) => this.unitOfWork = unitOfWork;

        /// <inheritdoc />
        public Task<IEnumerable<ViewModel>> FetchAsync(FilterModel model)
        {
            var where = " WHERE 1 = 1 ";
            if (!string.IsNullOrEmpty(model.Name))
            {
                where += $@" AND TRIM(UPPER(""Name"")) = '{model.Name.Trim().ToUpper()}'";
            }

            //if (model.Active != null)
            //{
            //    where += $@" AND ""Active"" IS {((bool)model.Active ? "TRUE" : "FALSE")}";
            //}

            var query = $@"SELECT COUNT(*) OVER () AS ""TotalItems"", * FROM ""AssessmentType"" {where} Order by ""AssessmentTypeId"" DESC";

            if (model.PageIndex <= 0)
            {
                return this.unitOfWork.Current.QueryAsync<ViewModel>(query);
            }

            model.PageIndex -= 1;
            query += " LIMIT " + model.PageSize + " offset " + (model.PageIndex * model.PageSize);
            return this.unitOfWork.Current.QueryAsync<ViewModel>(query);
        }

        /// <inheritdoc />
        public async Task<int> AddAsync(InsertModel model)
        {
            var checkIf = await this.unitOfWork.Current.QueryFirstOrDefaultAsync<int>($@"SELECT COUNT(""AssessmentTypeId"") FROM ""AssessmentType"" WHERE TRIM(UPPER(""Name"")) = '{model.Name.ToUpper().Trim()}'");
            if (checkIf > 0)
            {
                return -1;
            }

            var assessmentType = new AssessmentType
            {

                Name = model.Name,
                CreatedBy = model.CreatedBy,
                CreatedDate = DateTime.Now,

            };

            return await this.unitOfWork.AssessmentType.InsertAsync(assessmentType);
        }

        /// <inheritdoc />
        public async Task<int> UpdateAsync(UpdateModel model)
        {
            var checkIf = await this.unitOfWork.Current.QueryFirstOrDefaultAsync<int>($@"SELECT COUNT(""AssessmentTypeId"") FROM ""AssessmentType"" WHERE TRIM(UPPER(""Name"")) = '{model.Name.ToUpper().Trim()}' AND ""AssessmentTypeId"" <> {model.AssessmentTypeId}");
            if (checkIf > 0)
            {
                return -1;
            }

            var assessmentType = await this.unitOfWork.AssessmentType.FindAsync(m => m.AssessmentTypeId == model.AssessmentTypeId);
            assessmentType.Name = model.Name;
            assessmentType.ModifiedBy = model.ModifiedBy;
            assessmentType.ModifiedDate = DateTime.Now;
            return await this.unitOfWork.AssessmentType.UpdateAsync(assessmentType);
        }

        /// <inheritdoc />
        public async Task<int> DeleteAsync(DeleteModel id)
        {
            var response = await this.unitOfWork.AssessmentType.DeleteAsync(x => x.AssessmentTypeId == id.AssessmentTypeId);
            return response ? 1 : -1;
        }

        public async Task<string> FindNameByAssessmentTypeId(int id)
        {
            var query = $@"SELECT ""Name"" FROM ""AssessmentType"" WHERE ""AssessmentTypeId"" = {id}";
            var response = await this.unitOfWork.Current.QuerySingleOrDefaultAsync<string>(query);
            return response;
        }        
    }
}