﻿namespace Hims.Shared.Library.Enums
{
    /// <summary>
    /// The notification intimate.
    /// </summary>
    public enum NotificationType
    {
        /// <summary>
        /// The killed other sessions
        /// </summary>
        KilledOtherSessions = 1,

        /// <summary>
        /// The requested emergency call
        /// </summary>
        RequestedEmergencyCall = 2,

        /// <summary>
        /// The appointment booked
        /// </summary>
        AppointmentBooked = 3,

        /// <summary>
        /// The appointment rescheduled
        /// </summary>
        AppointmentRescheduled = 4,

        /// <summary>
        /// The appointment cancelled
        /// </summary>
        AppointmentCancelled = 5,

        /// <summary>
        /// The appointment confirmed
        /// </summary>
        AppointmentConfirmed = 6,

        /// <summary>
        /// The appointment delayed
        /// </summary>
        AppointmentDelayed = 7,

        /// <summary>
        /// Creates new message.
        /// </summary>
        NewMessageFromPatient = 8,

        /// <summary>
        /// Creates new messagefromdoctor.
        /// </summary>
        NewMessageFromDoctor = 9,

        /// <summary>
        /// The appointment subcribed
        /// </summary>
        AppointmentSubcribed = 10,

        /// <summary>
        /// The test notification
        /// </summary>
        TestNotification = 11,

        /// <summary>
        /// The prescription.
        /// </summary>
        PrescriptionAdded = 12,

        /// <summary>
        /// The prescription updated.
        /// </summary>
        PrescriptionUpdated = 13,

        /// <summary>
        /// The full transcription.
        /// </summary>
        FullTranscriptionAdded = 14,

        /// <summary>
        /// The full transcription updated.
        /// </summary>
        FullTranscriptionUpdated = 15,

        /// <summary>
        /// The documents.
        /// </summary>
        PatientUploadedDocuments = 16,

        /// <summary>
        /// The doctor uploaded documents.
        /// </summary>
        DoctorUploadedDocuments = 17,

        /// <summary>
        /// The documents edit.
        /// </summary>
        PatientEditedDocuments = 18,

        /// <summary>
        /// The doctor edited documents.
        /// </summary>
        DoctorEditedDocuments = 19,

        /// <summary>
        /// The documents edit.
        /// </summary>
        PatientDeletedDocuments = 20,

        /// <summary>
        /// The doctor edited documents.
        /// </summary>
        DoctorDeletedDocuments = 21,

        /// <summary>
        /// The incoming call
        /// </summary>
        IncomingCall = 22,

        /// <summary>
        /// The chat
        /// </summary>
        Chat = 23,

        /// <summary>
        /// The telemedicine call
        /// </summary>
        TelemedicineCall = 24,

        /// <summary>
        /// The notification intimate
        /// </summary>
        NotificationIntimate = 25,

        /// <summary>
        /// The call.
        /// </summary>
        Call = 26,

        /// <summary>
        /// The notify.
        /// </summary>
        Notify = 27,

        /// <summary>
        /// The reject.
        /// </summary>
        Reject = 28,

        /// <summary>
        /// The intimate alt one.
        /// </summary>
        CloseAll = 29,

        /// <summary>
        /// The intimate alt one.
        /// </summary>
        Join = 30,

        /// <summary>
        /// The intimate alt one.
        /// </summary>
        Close = 31,

        /// <summary>
        /// The cancel.
        /// </summary>
        Cancel = 32,

        /// <summary>
        /// The frequent call
        /// </summary>
        FrequentCall = 33,

        /// <summary>
        /// The video call initiate
        /// </summary>
        VideoCallInitiate = 34,

        /// <summary>
        /// The audio call initiate
        /// </summary>
        AudioCallInitiate = 35,

        /// <summary>
        /// The medication documents
        /// </summary>
        MedicationDocuments=36
    }
}
