﻿using System.Text.Json.Serialization;
using Hims.Domain.Entities.Enums;

namespace Hims.Shared.UserModels.Receipt
{
    using System;

    /// <summary>
    /// The receipt model
    /// </summary>
    public class ViewModel
    {
        /// <summary>
        /// Gets or sets the admission identifier.
        /// </summary>
        /// <value>
        /// The admission identifier.
        /// </value>
        public int AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the receipt identifier.
        /// </summary>
        /// <value>
        /// The receipt identifier.
        /// </value>
        public int ReceiptId { get; set; }

        /// <summary>
        /// Gets or sets the cost.
        /// </summary>
        /// <value>
        /// The cost.
        /// </value>
        public double Cost { get; set; }

        /// <summary>
        /// Gets or sets the receipt type identifier.
        /// </summary>
        /// <value>
        /// The receipt type identifier.
        /// </value>
        public string ReceiptTypeName { get; set; }

        /// <summary>
        /// Gets or sets the receipt type identifier.
        /// </summary>
        /// <value>
        /// The receipt type identifier.
        /// </value>
        public int ReceiptTypeId { get; set; }

        /// <summary>
        /// Gets or sets the pay type identifier.
        /// </summary>
        /// <value>
        /// The pay type identifier.
        /// </value>
        public int PayTypeId { get; set; }

        /// <summary>
        /// Gets or sets the payment details.
        /// </summary>
        /// <value>
        /// The payment details.
        /// </value>
        public string PaymentDetails { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="Receipt"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is advance.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is advance; otherwise, <c>false</c>.
        /// </value>
        public bool IsAdvance { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is dicharged.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is dicharged; otherwise, <c>false</c>.
        /// </value>
        public bool IsDischarged { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is refunded.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is refunded; otherwise, <c>false</c>.
        /// </value>
        public bool IsRefunded { get; set; }

        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the created by role.
        /// </summary>
        /// <value>
        /// The created by role.
        /// </value>
        public string CreatedByRole { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the name of the modified by.
        /// </summary>
        /// <value>
        /// The name of the modified by.
        /// </value>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified by role.
        /// </summary>
        /// <value>
        /// The modified by role.
        /// </value>
        public string ModifiedByRole { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        /// <value>
        /// The full name.
        /// </value>
        public string FullName { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is appointment receipt.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is appointment receipt; otherwise, <c>false</c>.
        /// </value>
        public bool IsAppointmentReceipt { get; set; }

        /// <summary>
        /// Gets or sets the receipt area type identifier.
        /// </summary>
        /// <value>
        /// The receipt area type identifier.
        /// </value>
        public ReceiptAreaType? ReceiptAreaTypeId { get; set; }

        /// <summary>
        /// Gets or sets the receipt area main identifier.
        /// </summary>
        /// <value>
        /// The receipt area main identifier.
        /// </value>
        public int? ReceiptAreaMainId { get; set; }

        /// <summary>
        /// Gets or sets the pay type name.
        /// </summary>
        public string PayTypeName { get; set; }

        /// <summary>
        /// Gets or sets the pay type name.
        /// </summary>
        public bool IsSalucroAdmissionReceipt { get; set; }
    }
}
