﻿using Hims.Shared.UserModels.Slots;
using System;
using System.Collections.Generic;
using System.Text;

namespace Hims.Shared.UserModels.Scan.ScanMachineAvailability
{
    public class ScanMachineAvailabilityBasedOnDaysModel
    {
        /// <summary>
        /// Gets or sets the scan test master id.
        /// </summary>
        public int? ScanTestMasterId { get; set; }
        /// <summary>
        /// Gets or sets the count.
        /// </summary>
        public int? Count { get; set; }
        /// <summary>
        /// Gets or sets the scan test name.
        /// </summary>
        public string? ScanTestName { get; set; }
        /// <summary>
        /// Gets or sets the duration.
        /// </summary>
        public int? Duration { get; set; }
        /// <summary>
        /// Gets or sets the machine name.
        /// </summary>
        public string? MachineName { get; set; }
        /// <summary>
        /// Gets or sets the scan machine master id.
        /// </summary>
        public int? ScanMachineMasterId { get; set;}
        /// <summary>
        /// Gets or sets location id.
        /// </summary>
        public int? LocationId { get; set; }    

        /// <summary>
        /// Gets or sets the appointment date.
        /// </summary>
        public DateTime? AppointmentDate { get; set; }
        /// <summary>
        /// Gets or sets the from date.
        /// </summary>
        public string? FromDate { get; set; }
        /// <summary>
        /// Gets or sets the to date.
        /// </summary>
        public string? ToDate { get; set; }

        /// <summary>
        /// Gets or sets the type.
        /// </summary>
        public string Type { get; set; }


    }


    public class ScanSlotModel
    {

        /// <summary>
        /// Gets or sets the slot value.
        /// </summary>
        public string SlotValue { get; set; }

        /// <summary>
        /// Gets or sets the slot time.
        /// </summary>
        public TimeSpan SlotTime { get; set; }

        /// <summary>
        /// Gets or sets the slot name.
        /// </summary>
        public string SlotName { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public SlotStatus Status { get; set; }

        /// <summary>
        /// Gets or sets the token number.
        /// </summary>
        /// <value>
        /// The token number.
        /// </value>
        public int TokenNumber { get; set; }

        /// <summary>
        /// Gets or sets the charge.
        /// </summary>
        public int? Charge { get; set; }

        /// <summary>
        /// Gets or sets the duration
        /// </summary>
        public int? Duration { get; set; }

        /// <summary>
        /// Gets or sets or sets the provider Availbaility id.
        /// </summary>
        public int? ProviderAvailabilityId { get; set; }

        /// <summary>
        /// Gets or sets the provider availability chargeType id
        /// </summary>
        public int? DoctorSpecializationChargeModuleDetailsId { get; set; }

        /// <summary>
        /// Gets or sets the value.
        /// </summary>
        public string? Value { get; set; }

        /// <summary>
        /// Gets or sets the SlotValue24HoursEnd.
        /// </summary>
        public string SlotValue24HoursEnd { get; set; }

        /// <summary>
        /// Gets or sets the slot name.
        /// </summary>
        public string SlotName12HoursEnd { get; set; }
        /// <summary>
        /// Gets or sets the available date.
        /// </summary>
        public string? AvailableDate { get; set; }
        /// <summary>
        /// Gets or sets the id.
        /// </summary>
        public string? Id { get; set; }

        /// <summary>
        /// Gets or sets the slot type.
        /// </summary>
        public SlotType SlotType { get; set; }
        /// <summary>
        /// Gets or sets the machine master id.
        /// </summary>
        public int? ScanMachineMasterId { get; set; }
        /// <summary>
        /// Gets or sets the end time.
        /// </summary>
        public string? EndTime { get; set; }
       


    }

    public class MachineSlots
    {
        /// <summary>
        /// Gets or sets the machine name.
        /// </summary>
        public string MachineName { get; set; }
        /// <summary>
        /// Gets or sets the list of scan time slots.
        /// </summary>
        public List<ScanSlotModel> ScanTimeSlot { get; set; }
        /// <summary>
        /// Gets or sets the message.
        /// </summary>
        public string? Meassage { get; set; }

        /// <summary>
        /// Gets or sets the scan machine master id.
        /// </summary>
        public int? ScanMachineMasterId { get; set; }
    }

    public class DateWiseMachines
    {
        /// <summary>
        /// Gets or sets the dates.
        /// </summary>
        public string Dates { get; set; }
        /// <summary>
        /// Gets or sets list of machine slots.
        /// </summary>
        public List<MachineSlots> MachineSlots { get; set; }
        /// <summary>
        /// Gets or sets availability meassage.
        /// </summary>
        public string? AvailabilityMessage { get; set; }
    }

    public class AppointmentTimings
    {
        /// <summary>
        /// Gets or sets the start time.
        /// </summary>
        public TimeSpan AppointmentTime { get; set; }

        /// <summary>
        /// Gets or sets the end time.
        /// </summary>
        public TimeSpan AppointmentEndTime { get; set; }
    }
}
