﻿namespace Hims.Domain.Services
{
    using System;
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Hims.Domain.Entities;
    using Shared.EntityModels;
    using Shared.UserModels;
    using Shared.UserModels.Filters;

    /// <summary>
    /// the provider service interface
    /// </summary>
    public interface IProviderService
    {
        Task<Provider> GetRawAsync(int id);

        /// <summary>
        /// The check provider async.
        /// </summary>
        /// <param name="mobile">
        /// The mobile.
        /// </param>
        /// <param name="countryId">
        /// The country id.
        /// </param>
        /// <param name="npi">
        /// The npi.
        /// </param>
        /// <param name="email">
        /// The email.
        /// </param>
        /// <param name="providerId">
        /// The provider id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> CheckProviderAsync(string mobile, int? countryId, string npi, string email, int providerId);

        /// <summary>
        /// The register async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> RegisterAsync(ProviderRegistrationModel model);

        /// <summary>
        /// The register async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<Tuple<int, Guid?>> SelfRegisterAsync(SelfRegistrationModel model);

        /// <summary>
        /// The register async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> OTPVerificationAsync(SelfRegistrationModel model);

        /// <summary>
        /// The approve async.
        /// </summary>
        /// <param name="providerId">
        /// The provider id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<ProviderModel> ApproveAsync(int providerId);

        /// <summary>
        /// The reject async.
        /// </summary>
        /// <param name="providerId">
        /// The provider id.
        /// </param>
        /// <param name="rejectedComments">
        /// The rejected comments.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<ProviderModel> RejectAsync(int providerId, string rejectedComments);

        /// <summary>
        /// The find async.
        /// </summary>
        /// <param name="providerId">
        /// The provider id.
        /// </param>
        /// <param name="locationId"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<ProviderModel> FindAsync(int providerId, int? locationId, int? specializationId);

        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<ProviderModel>> FetchAsync(ProviderFilterModel model);

        /// <summary>
        /// The fetch list items async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<ProviderListItemModel>> FetchListItemsAsync(ProviderListItemFilterModel model);

        /// <summary>
        /// The update async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UpdateAsync(ProviderModel model);

        /// <summary>
        /// The Add async
        /// </summary>
        /// <param name="model">
        /// The model
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<Tuple<int, int, Guid?>> AddAsync(ProviderModel model);

        /// <summary>
        /// The update image urls async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <param name="guid">
        /// The guid.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UpdateImageUrlsAsync(ProviderModel model, Guid guid);

        /// <summary>
        /// The update image urls async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <param name="guid">
        /// The guid.
        /// </param> 
        /// /// <param name="profileImageUrl">
        /// The guid.
        /// </param> 
        /// /// <param name="thumbnailUrl">
        /// The guid.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UpdateThumbnailImageUrlsAsync(string profileImageUrl, string thumbnailUrl, Guid guid);

        /// <summary>
        /// The delete async.
        /// </summary>
        /// <param name="providerId">
        /// The provider id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> DeleteAsync(int providerId);

        /// <summary>
        /// The update profile async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UpdateProfileAsync(ModifyProviderProfileModel model);

        /// <summary>
        /// The locked status async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> LockedStatusAsync(ProviderModel model);

        /// <summary>
        /// The provider list.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<ProviderListItemModel>> ProviderList(ProviderListItemFilterModel model);

        /// <summary>
        /// The get provider availability async.
        /// </summary>
        /// <param name="providerIds">
        /// The provider id.
        /// </param>
        /// /// <param name="providerLocationId">
        /// The provider id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<ProviderListItemModel>> GetProviderAvailabilityAsync(string providerIds, int? providerLocationId);

        /// <summary>
        /// The find provider details.
        /// </summary>
        /// <param name="email"></param>
        /// <param name="mobile"></param>
        /// The provider email.
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        int FindProviderIdByAsync(string email, string mobile);

        /// <summary>
        /// The update signature urls async.
        /// </summary>
        /// <param name="signature">
        /// The signature.
        /// </param>
        /// <param name="logo">
        /// The logo.
        /// </param>
        /// <param name="guid">
        /// The guid.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UpdateSignatureUrlsAsync(string signature, string logo, Guid guid);

        /// <summary>
        /// The update signature urls async.
        /// </summary>
        /// <param name="profileImageUrl">
        /// The signature.
        /// </param>
        /// <param name="thumbnailUrl">
        /// The logo.
        /// </param>
        /// <param name="guid">
        /// The guid.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UpdateProfileImageUrlsAsync(string profileImageUrl, string thumbnailUrl, Guid guid);


        /// <summary>
        /// The get provider availability async.
        /// </summary>
        /// <param name="providerId">
        /// The provider id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<ProviderModel> FindProviderByProviderId(int providerId);

        /// <summary>
        /// The get provider availability async.
        /// </summary>
        /// <param name="providerId">
        /// The provider id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<string> FindProviderByAdmissionId(int providerId);

        /// <summary>
        /// The get provider availability async.
        /// </summary>
        /// <param name="providerLocationId">
        /// The provider id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> FindLocationIdByProviderLocationId(int providerLocationId);

        /// <summary>
        /// Adds the provider consultation room.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> AddProviderConsultationRoom(ProviderConsultationRoomModel model);

        /// <summary>
        /// Fetches the providers room.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<BedManagementModel>> FetchProvidersRoom(ProviderConsultationRoomModel model);

        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model">
        /// The patient model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<ProviderSpecializationModel>> FetchDoctorSpecializationAsync(ProviderSpecializationModel model);

        /// <summary>
        /// The fetch list items async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<ProviderListItemModel>> FetchProviderListItemsAsync(ProviderListItemFilterModel model);
        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model">
        /// The patient model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<ProviderSpecializationModel>> FetchDoctorSpecializationOpAsync(ProviderSpecializationModel model);
    }
}
