﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.EntityModels;
    using Shared.UserModels.Filters;

    /// <summary>
    /// The Coupon Service interface.
    /// </summary>
    public interface ISettingService
    {
        

        ///// <summary>
        ///// The fetch async.
        ///// </summary> 
        // /// <param name="model">
        ///// The model
        ///// </param>
        ///// <returns>
        ///// The <see cref="Task"/>.
        ///// </returns>
        //Task<int> UpdateMessageSetting(SettingModel model);

        /// <summary>
        /// The insert queue async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<int> AppointmentSettingAsync(PrintSettingModel model);

        /// <summary>
        /// fetch status async
        /// </summary>
        /// <returns>The <see cref="Task"/></returns>
        Task<bool> CheckSmsEnabled();

        /// <summary>
        /// fetch status async
        /// </summary>
        /// <returns>The <see cref="Task"/></returns>
        Task<bool> CheckEmailEnabled();

        /// <summary>
        /// the insert async
        /// </summary>
        /// <param name="model"></param>
        /// <returns>The <see cref="Task"/></returns>
        Task<int> InsertAsync(SettingModel model);

        /// <summary>
        /// The fetch async.
        /// </summary>      
        /// <returns>
        /// <param name="name"></param>
        /// <param name="type"></param>
        /// <param name="active"></param>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<SettingModel>> FetchAsync(string name, string type, bool? active);

        /// <summary>
        /// the insert async
        /// </summary>
        /// <param name="model"></param>
        /// <returns>The <see cref="Task"/></returns>
        Task<int> UpdateAsync(SettingModel model);

    }
}
