﻿using System.Collections.Generic;

namespace Hims.Shared.UserModels.Package
{
    /// <summary>
    /// The coupon.
    /// </summary>
    public class ViewModel
    {
        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        /// <value>
        /// The name.
        /// </value>
        public string Name { get; set; }
        /// <summary>
        /// Gets or sets the package identifier.
        /// </summary>
        /// <value>
        /// The package identifier.
        /// </value>
        public int PackageId { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        /// <value>
        /// The amount.
        /// </value>
        public double Amount { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="ViewModel"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the total general.
        /// </summary>
        /// <value>
        /// The total general.
        /// </value>
        public int? TotalGeneral { get; set; }

        /// <summary>
        /// Gets or sets the total medicines.
        /// </summary>
        /// <value>
        /// The total medicines.
        /// </value>
        public int? TotalMedicines { get; set; }

        /// <summary>
        /// Gets or sets the total labs.
        /// </summary>
        /// <value>
        /// The total labs.
        /// </value>
        public int? TotalLabs { get; set; }

        /// <summary>
        /// Gets or sets the total kits.
        /// </summary>
        /// <value>
        /// The total kits.
        /// </value>
        public int? TotalKits { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        /// <value>
        /// The total items.
        /// </value>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the location ids.
        /// </summary>
        /// <value>
        /// The location ids.
        /// </value>
        public string LocationIds { get; set; }


        /// <summary>
        /// Gets or sets the name of the location.
        /// </summary>
        /// <value>
        /// The name of the location.
        /// </value>
        public string? LocationNames { get; set; }

    }
}
