﻿namespace Hims.Shared.UserModels
{
    using System.Collections.Generic;
    using EntityModels;

    /// <summary>
    /// The patient profile model.
    /// </summary>
    public class PatientProfileModel
    {
        /// <summary>
        /// Gets or sets the patient.
        /// </summary>
        public PatientModel Patient { get; set; }

        /// <summary>
        /// Gets or sets the emergency contacts.
        /// </summary>
        public IEnumerable<PatientEmergencyModel> EmergencyContacts { get; set; }

        /// <summary>
        /// Gets or sets the insurances.
        /// </summary>
        public IEnumerable<PatientInsuranceModel> Insurances { get; set; }

        ///// <summary>
        ///// Gets or sets the patientFamily.
        ///// </summary>
        //public PatientFamilyModel PatientFamily { get; set; }

        /// <summary>
        /// Gets or sets the relative details.
        /// </summary>
        public IEnumerable<PatientFamilyModel> RelativeDetails { get; set; }
    }
}