﻿import { ReceiptType } from "./receipt-type.model";
import { PayType } from "./pay-type.model";
import { ReceiptAreaType } from "../../../../shared/entities";

export interface IReceiptModel {
    receiptId: number;
    receiptNo: string;
    payTypeId: PayType;
    payTypeName: string;
    receiptTypeId: ReceiptType;
    paymentDetails: string;
    admissionId: number;
    cost: number;
    receiptTypeName: string;
    createdByName: string;
    createdDate: Date;
    modifiedDate: Date;
    modifiedByName: string;
    active: boolean;
    isAdvance: boolean;
    isRefunded: boolean;
    isSpecial: boolean;
    fullName: string;
    cancelling: boolean;
    isAppointmentReceipt: boolean;

    receiptAreaTypeId?: ReceiptAreaType;
    receiptAreaMainId?: number;
    subRecords?: Array<IReceiptSubModel>;
    costModel?: IReceiptCostModel;
    isSalucroAdmissionReceipt: boolean;
}

export interface IReceiptSubModel {
    cost: number;
    discountAmount: number;
    discountPercentage: number;
    gstAmount: number;
    gstPercentage: number;
    name: string;
    netAmount: number;
    totalAmount: number;
    unit: number;
}

export interface IReceiptCostModel {
    total: number;
    discount: number;
    gst: number;
    netAmount: number;
}