﻿using Hims.Shared.Dapper.Attributes;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace Hims.Domain.Entities
{
    public class BookScanAppointment
    {
        /// <summary>
        /// Gets or sets the book scan appointment id.
        /// </summary>
        [Key, Identity]
        public int BookScanAppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the scan machine master id.
        /// </summary>
        public int ScanMachineMasterId { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the payment status.
        /// </summary>
        public bool PaymentStatus { get; set; }

        /// <summary>
        /// Gets or sets the pay type id.
        /// </summary>
        public int? PayTypeId { get; set; }

        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the appointment date.
        /// </summary>
        public DateTime AppointmentDate { get; set; }

        /// <summary>
        /// Gets or sets the appointment time.
        /// </summary>
        public TimeSpan AppointmentTime { get; set; }

        /// <summary>
        /// Gets or sets the payment number.
        /// </summary>
        public string PaymentNumber { get; set; }

        /// <summary>
        /// Gets or sets the scan test master id.
        /// </summary>
        public int ScanTestMasterId { get; set; }

        /// <summary>
        /// Gets or sets the old appointment time.
        /// </summary>
        public TimeSpan? OldAppointmentTime { get; set; }

        /// <summary>
        /// Gets or sets the old appointment date.
        /// </summary>
        public DateTime? OldAppointmentDate { get; set; }

        /// <summary>
        /// Gets or sets the reason.
        /// </summary>
        public string Reason { get; set; }

        /// <summary>
        /// Gets or sets the reason.
        /// </summary>
        public string RescheduleReason { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public string Status { get; set; } = "B";

        /// <summary>
        /// Gets or sets the booked status.
        /// </summary>
        public string BookedStatus { get; set; }

        /// <summary>
        /// Gets or sets the appointment end time.
        /// </summary>
        public TimeSpan AppointmentEndTime { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        public double Amount { get; set; }

        /// <summary>
        /// Gets or sets the charge category id.
        /// </summary>
        public int? ChargeCategoryId { get; set; }

        /// <summary>
        /// Gets or sets the is salucro appointment.
        /// </summary>
        public bool IsSalucroAppointment { get; set; }

        /// <summary>
        /// Gets or sets the requisition number.
        /// </summary>
        public string RequisitionNumber { get; set; }

        /// <summary>
        /// Gets or sets the Indication.
        /// </summary>
        public string Indication { get; set; }

        /// <summary>
        /// Gets or sets the authorityId.
        /// </summary>
        public int? AuthorityId { get; set; }

        /// <summary>
        /// Gets or sets the reasonId.
        /// </summary>
        public int? ReasonId { get; set; }

        /// <summary>
        /// Gets or sets the discountPerItem.
        /// </summary>
        public int? DiscountPercentage { get; set; }

        /// <summary>
        /// Gets or sets the discountPerItemInRupees.
        /// </summary>
        public double? DiscountAmount { get; set; }

        /// <summary>
        /// Gets or sets the insurance id.
        /// </summary>
        public char? PaymentType { get; set; }

        /// <summary>
        /// Gets or sets the Scan Appointment Type.
        /// </summary>
        public string ScanAppointmentType { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        public double? ActualAmount { get; set; }
        public string Gravida { get; set; }
        public string PeriodOfGestation { get; set; }
        public DateTime? EDD { get; set; }
        public bool? Obstetric { get; set; }
        public string AccompaniedBy { get; set; }
        public string Findings { get; set; }
        public string Remarks { get; set; }
        public string Reasons { get; set; }
        public string Dispatched { get; set; }
        public string BabyDetails { get; set; }
        public bool PndtReport { get; set; }
        public int? ScanScrollResult { get; set; }
        public bool IsDispatched { get; set; }
        public bool IsPatRegPaid { get; set; }
        public int? ProviderId { get; set; }
    }
}
