﻿using Hims.Domain.Entities.Enums;

namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;

    using Hims.Shared.Dapper.Attributes;

    /// <summary>
    /// The receipt model
    /// </summary>
    public class Receipt
    {
        /// <summary>
        /// Gets or sets the chat identifier.
        /// </summary>
        /// <value>
        /// The chat identifier.
        /// </value>
        [Key, Identity]
        public int ReceiptId { get; set; }

        /// <summary>
        /// Gets or sets the admission identifier.
        /// </summary>
        /// <value>
        /// The admission identifier.
        /// </value>
        public int? AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the appointment identifier.
        /// </summary>
        /// <value>
        /// The appointment identifier.
        /// </value>
        public int? AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the cost.
        /// </summary>
        /// <value>
        /// The cost.
        /// </value>
        public double Cost { get; set; }

        /// <summary>
        /// Gets or sets the receipt type identifier.
        /// </summary>
        /// <value>
        /// <c>cash</c> if credit; otherwise, <c>Refund</c> for Debt
        /// </value>
        public ReceiptType ReceiptTypeId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="Receipt"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is advance.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is advance; otherwise, <c>false</c>.
        /// </value>
        public bool IsAdvance { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is refunded.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is refunded; otherwise, <c>false</c>.
        /// </value>
        public bool? IsRefunded { get; set; }

        /// <summary>
        /// Gets or sets the pay type identifier.
        /// </summary>
        /// <value>
        /// The pay type identifier.
        /// </value>
        public int? PayTypeId { get; set; }

        /// <summary>
        /// Gets or sets the payment details.
        /// </summary>
        /// <value>
        /// The payment details.
        /// </value>
        public string PaymentDetails { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is appointment receipt.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is appointment receipt; otherwise, <c>false</c>.
        /// </value>
        public bool IsAppointmentReceipt { get; set; }
        
        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }
        
        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the receipt area type identifier.
        /// </summary>
        /// <value>
        /// The receipt area(module-wise) type identifier.
        /// </value>
        public ReceiptAreaType? ReceiptAreaTypeId { get; set; }

        /// <summary>
        /// Gets or sets the respective identifier acording to receipt type area.
        /// </summary>
        /// <value>
        /// The  identifier.
        /// </value>
        public int? RespectiveId { get; set; }
      
        /// <summary>
        /// Gets or sets the receipt area main identifier.
        /// </summary>
        /// <value>
        /// The receipt area main identifier.
        /// </value>
        public int? ReceiptAreaMainId { get; set; }

        /// <summary>
        /// Gets or sets the patient registration detail identifier.
        /// </summary>
        /// <value>
        /// The patient registration detail identifier.
        /// </value>
       // public int? PatientRegistrationDetailId { get; set; }

        /// <summary>
        /// Gets or sets the transaction identifier.
        /// </summary>
        /// <value>
        /// The transaction identifier.
        /// </value>
        public int? TransactionId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is Salucro Admission Receipt.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is advance; otherwise, <c>false</c>.
        /// </value>
        public bool IsSalucroAdmissionReceipt { get; set; }

        /// <summary>
        /// Gets or sets the master bill identifier.
        /// </summary>
        /// <value>
        /// The master bill identifier.
        /// </value>
        public int? MasterBillId { get; set; }
    }
}
