﻿#nullable enable
namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.UserModels.Exports;

    /// <summary>
    /// The ExportService interface.
    /// </summary>
    public interface IExportService
    {
        /// <summary>
        /// The fetch payments.
        /// </summary>
        /// <param name="fromDate">
        /// The from Date.
        /// </param>
        /// <param name="toDate">
        /// The to Date.
        /// </param>
        /// <param name="providerId">
        /// The provider Id.
        /// </param>
        /// <param name="pageIndex">
        /// The page Index.
        /// </param>
        /// <param name="pageSize">
        /// The page Size.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PaymentExportModel>> FetchPaymentsAsync(string? fromDate, string? toDate, int? providerId, int pageIndex, int pageSize);
    }
}
