﻿using System.Collections.Generic;
using System.Threading.Tasks;
using Hims.Shared.UserModels.Package;
using Product = Hims.Shared.UserModels.Package.Product;
using Surgery = Hims.Shared.UserModels.Package.Surgery;
using MetaData = Hims.Shared.UserModels.Package.MetaData;

namespace Hims.Domain.Services
{
    /// <summary> The ChatService interface.</summary>
    public interface IPackageService
    {
        /// <summary>
        /// Deletes the package charge asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> DeletePackageChargeAsync(DeleteModel model);

        /// <summary>
        /// Updates the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> UpdateAsync(UpdateModel model);

        /// <summary>
        /// Deletes the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> DeleteAsync(MetaData.FilterModel model);

        /// <summary>
        /// Fetches the meta data asynchronous.
        /// </summary>
        /// <param name="packageId">The package identifier.</param>
        /// <param name="locationId"></param>
        /// <returns></returns>
        Task<MetaData.ViewModel> FetchMetaDataAsync(int packageId, int locationId);

        /// <summary>
        /// Fetches the surgery kits asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<Surgery.ViewModel>> FetchSurgeryKitsAsync(Surgery.FilterModel model);

        /// <summary>
        /// Fetches the surgery masters asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<Surgery.BasicViewModel>> FetchSurgeryMastersAsync();

        /// <summary>
        /// Fetches the product masters asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<Product.BasicViewModel>> FetchProductMastersAsync();

        /// <summary>
        /// Fetches the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<Product.ViewModel>> FetchProductsAsync(Product.FilterModel model);

        /// <summary>
        /// Inserts the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> InsertAsync(InsertModel model);

        /// <summary>
        /// Fetches the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<ViewModel>> FetchAsync(FilterModel model);

        /// <summary>
        /// The get provider availability async.
        /// </summary>
        /// <param name="model">The model.</param>">
        /// The provider id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<string> FindNameByPackageId(int packageId);
    }
}
