import { ForgotPasswordPage } from "@account/forgot-password/forgot-password.page";
import { LoginPage } from "@account/login/login.page";
import { AccountsPage } from "@admin/accounts/accounts.page";
import { NgModule } from "@angular/core";
import { RouterModule, Routes } from "@angular/router";
import { NotFoundPage } from "@error/not-found/not-found.page";
import { ServerErrorPage } from "@error/server-error/server-error.page";
import { AccessGuard, AuthGuard, DeactivateGuard, TelemedicineGuard } from "@shared/guards";
import { LayoutComponent } from "./areas/layout/layout.component";

// STARTING PAGES
const startingRoutes = [
    { path: "login", canActivate: [AccessGuard], component: LoginPage, data: { title: "Login", anonymous: true } },
    { path: "forgot-password", canActivate: [AccessGuard], component: ForgotPasswordPage, data: { title: "Forgot Password", anonymous: true } }
]
const startingRouteComponents = [LoginPage, ForgotPasswordPage];

// ERROR PAGES
const errorRoutes = [
    { path: "not-found", component: NotFoundPage, data: { title: "Not Found" } },
    { path: "server-error", component: ServerErrorPage, data: { title: "Server Error" } },
]
const errorRouteComponents = [NotFoundPage, ServerErrorPage];

// HIDDEN PAGES
const hiddenPages = [
    { path: "accounts", component: AccountsPage, data: { title: "Accounts", } }
]
const hiddenPagesComponents = [AccountsPage];

const routes: Routes = [
    { path: "", redirectTo: "login", pathMatch: "full" },
    ...startingRoutes,
    ...errorRoutes,
    {
        path: "app",
        component: LayoutComponent,
        canActivate: [AuthGuard],
        canActivateChild: [AuthGuard],
        children: [
            { path: "", redirectTo: "dashboard", pathMatch: "full" },
            ...hiddenPages,
            {
                path: "masters",
                loadChildren: () => import('./areas/admin/masters/masters.module').then(m => m.MastersModule)
            },
            {
                path: "admissions",
                loadChildren: () => import('./areas/admin/admissions/admissions.module').then(m => m.AdmissionsModule)
            },
            {
                path: "ambulance",
                loadChildren: () => import('./areas/admin/ambulance/ambulance.module').then(m => m.AmbulanceModule)
            },
        ]
    },
    { path: "**", redirectTo: "not-found" },
];

// ----- ROUTING MODULE -----

@NgModule({
    imports: [RouterModule.forRoot(routes, { useHash: true, enableTracing: false, onSameUrlNavigation: "reload" })],
    exports: [RouterModule]
})
export class AppRoutingModule { }

export const routePages = [
    ...startingRouteComponents,
    ...errorRouteComponents,
    ...hiddenPagesComponents,
];
export const routeGuards = [AccessGuard, AuthGuard, DeactivateGuard, TelemedicineGuard];