﻿import { Component, OnDestroy, OnInit, ViewEncapsulation, TemplateRef } from "@angular/core";
import { ApiResources, UtilHelper, DateHelper } from "@shared/helpers";
import { AppData, HttpService, NotifyService, ResourceService } from "@shared/services";
import { takeUntil, finalize } from "rxjs/operators";
import { HttpErrorResponse } from "@angular/common/http";
import { NgbModal, NgbModalRef, NgbDate} from "@ng-bootstrap/ng-bootstrap";
import { FormGroup, Validators, FormBuilder, FormArray } from "@angular/forms";
import { Page, IUserAccount, Pagination, IResource, GenericResponse } from "@shared/models";
import { ProviderScheduleCharges } from "@shared/entities/provider-schedule-charges.entity";
import { LookUpModel } from "../../../services/models/look-up.model";
import { ProviderSpecialization } from "../../../../../shared/entities/provider-specialization.entity";
import { NgSelectComponent } from '@ng-select/ng-select';
import moment from "moment";
class TrackBy {
    providerSchedulerCharges(item: ProviderScheduleCharges) {
        return item.providerId;
    }
    resource(item: IResource) {
        return item.id;
    }
}
   
class FilterOptions {
    locationId: number = null;
    providerId: number = null;
    specializationId: number = null;
    departmentId: number = null;
    consultationTypeId: number = null;
    fromDate: string = null;// = moment().format("YYYY-MM-DD");
    toDate: string = null; //= moment().format("YYYY-MM-DD");
    active: boolean = true;
}

class Filters {
    options: FilterOptions;
    applied: boolean;

    constructor() {
        this.init();
    }

    init() {
        this.options = new FilterOptions();
        this.applied = undefined;
    }
}
class partsOfDay {
    partsOfDayId: number;
    partsOfDayName: string;
    active: boolean;
    createdBy: number;
    createdDate: string;
    modifiedBy: number;
    modifiedDate: string;
}

@Component({
    templateUrl: "./provider-schedule-charges.html",
    encapsulation: ViewEncapsulation.None
})
export class ProviderScheduleChargesPage implements OnInit, OnDestroy {
    page: Page;
    filters: Filters;
    trackBy: TrackBy;
    pagination: Pagination;
    providerScheduleChargeForm: FormGroup;
    loading: boolean;
    providerSchedulerCharges: Array<ProviderScheduleCharges>;
    setDatesForCharges: Array<ProviderScheduleCharges>;
    providerSchedulerChargeType: Array<ProviderScheduleCharges>;

    modalRef: NgbModalRef;
    submitting: boolean;
    submitted: boolean;
    modifying: boolean;
    modifyingContent: string;

    locations: Array<IResource>;

    visitors: Array<LookUpModel>;
    charges: Array<LookUpModel>;

    currencySymbol = "₹";

    providerSpecialization: Array<ProviderSpecialization>

    isVisitTypeloading: boolean;

    chargeDurationForm: FormGroup;
    doctorCharges: Array<ProviderScheduleCharges>;
    minDate = DateHelper.minDate;
    consultationType: Array<IResource>;
    loadingProviders: boolean;
    providers: Array<IResource>;
    loadingSpecialization: boolean;
    specializations: Array<IResource>;
    days: Array<partsOfDay>;
    locationId: number;
    providerResources: Array<IResource>;
    specializationResources: Array<IResource>;
    loadingproviderResources: boolean;
    loadingSpecializationResources: boolean;
    loadingconsultationTypes: boolean;
    todayDate = DateHelper.ngbToday;
    greaterThanToday=DateHelper.ngbToday;
   
    //setDate = DateHelper.ngbToday;
    setDate = NgbDate;
    setDate1: NgbDate;
   // today = DateHelper.ngbToday;
    setMaxDate: NgbDate;
    setMinDate: NgbDate;
    isSearchPatient: boolean = true;
    constructor(
        private readonly appData: AppData,
        private readonly modalService: NgbModal,
        private readonly formBuilder: FormBuilder,
        private readonly notifyService: NotifyService,
        private readonly httpService: HttpService,
        private readonly resourceService: ResourceService,
    ) {
        this.buildForm();
        this.page = new Page();
        this.filters = new Filters();
        this.trackBy = new TrackBy();
        this.initPagination();
        this.providers = new Array<IResource>();
        this.doctorCharges = new Array<ProviderScheduleCharges>();
        this.providerSchedulerCharges = new Array<ProviderScheduleCharges>();
        this.providerSchedulerChargeType = new Array<ProviderScheduleCharges>();
        this.locations = new Array<IResource>();
        this.specializations = new Array<IResource>();
        //this.todayDate = new Date();
    }


    //getMinDate() {
    //    const date = this.filters.options.fromDate.split("-");
    //    const year = Number(date[0]);
    //    const month = Number(date[1]);
    //    const day = Number(date[2]);
    //    this.setMinDate = new NgbDate(year, month, day);
    //}

    setFocus = (select: NgSelectComponent) => {
        select.open();
    }
    //getMaxDate() {
    //    const date = this.filters.options.toDate.split("-");
    //    const year = Number(date[0]);
    //    const month = Number(date[1]);
    //    const day = Number(date[2]);getMinDate
    //    this.setMaxDate = new NgbDate(year, month, day);
    //}
    getMinDate() {
        const date = this.filters.options.fromDate.split("-");
        const year = Number(date[0]);
        const month = Number(date[1]);
        const day = Number(date[2]);
        this.setMinDate = new NgbDate(year, month, day);
    }

    getMaxDate() {
        const date = this.filters.options.toDate.split("-");
        const year = Number(date[0]);
        const month = Number(date[1]);
        const day = Number(date[2]);
        this.setMaxDate = new NgbDate(year, month, day);
    }
    private initPagination() {
        this.pagination = new Pagination();
        this.pagination.pageIndex = 1;
        this.pagination.pageSize = 10;
    }

    private fetchProviderResources(departmentId?: number) {
        this.loadingproviderResources = true;
        this.resourceService.providerForSchdule(departmentId)
            .pipe(finalize(() => { this.loadingproviderResources = false }))
            .pipe(takeUntil(this.page.unSubscribe))
            .subscribe((response: Array<IResource>) => {
                this.providerResources = response;
            });
    }
    
    private fetchspecializationForProviderAvialability() {
        this.loadingSpecializationResources = true;
        this.resourceService.specializationForSchdule()
            .pipe(finalize(() => { this.loadingSpecializationResources = false }))
            .pipe(takeUntil(this.page.unSubscribe))
            .subscribe((response: Array<IResource>) => {
                this.specializationResources = response;
            });
    }

    providerChange(provider?: IResource) {
        if (provider != undefined) {
            this.fetchProviderSpecializations(provider.id);
        } if (provider == undefined) {
            this.fetchLocationSpecialization(this.page.userAccount.locationId);
        }
    }

    private buildForm() {
        this.providerScheduleChargeForm = this.formBuilder.group({
            providerAvailabilityChargeTypeId: 0,
            locationId: [null, [Validators.required]],
            specializationId: [null],
            providerId: [null],
            active: [true],
            consultationTypeId: [null, [Validators.required]],
            //partsOfDayId: [null, [Validators.required]],
            startDate: [null, [Validators.required]],
            endDate: [null, [Validators.required]],
            charges: this.formBuilder.array([]),
            followUpDays: 0,
            followUpDaysLimit: 0
        });
        
        //this.providerScheduleChargeForm.get("startDate").valueChanges.subscribe((value: any) => {
        //    debugger;
        //    const endDate = this.providerScheduleChargeForm.get("endDate").value
        //    const foundExist = this.providerSchedulerCharges.filter(x => x.startDate <= value && x.endDate >= endDate )
        //    if (foundExist.length > 0) {
        //        return this.notifyService.warningToast("Charges already exists");
        //    }
        //}
        //);


        //this.providerScheduleChargeForm.get("endDate").valueChanges.subscribe((value: any) => {
        //    debugger;
        //    const endDate = this.providerScheduleChargeForm.get("startDate").value
        //    const foundExist = this.providerSchedulerCharges.filter(x => x.startDate <= value && x.endDate >= endDate)
        //    if (foundExist.length > 0) {
        //        return this.notifyService.warningToast("Charges already exists");
        //    }
        //});
        
    }

    onProviderSelect(provider?: IResource) {
        if (provider != undefined) {
            this.fetchProviderSpecializations(provider.id);
        } if (provider == undefined) {
            this.fetchLocationSpecialization(this.locationId);
        }
        if (provider) {
            this.providerScheduleChargeForm.patchValue({
                providerId: provider.id
            });
            //this.httpService
            //    .post<Array<ProviderScheduleCharges>>(ApiResources.getURI(ApiResources.providerScheduleCharges.base, ApiResources.providerScheduleCharges.fetch), provider.id)
            //    .pipe(takeUntil(this.page.unSubscribe))
            //    .pipe(finalize(() => this.loading = false))
            //    .subscribe(
            //        (response: any) => {
            //            this.setDatesForCharges = response;
            //            this.setDatesForCharges.forEach((item) => {
            //                if (this.filters.options.fromDate <=item.startDate.toString()) {
            //                    this.providerScheduleChargeForm.patchValue({ endDate: this.providerScheduleChargeForm.value.startDate });
            //                }
            //            })
                        
            //        },
            //        () => {
            //            this.providerSchedulerCharges = [];
            //        }
            //    );
        } else {
            this.providerScheduleChargeForm.patchValue({
                providerId: null
            });
        }
    }

    get chargeType() {
        return this.chargeDurationForm.controls;
    }

    get chargeTypeFormArray() { return this.chargeDurationForm.controls["charges"] as FormArray }

    get chargeForm() {
        return this.chargeTypeFormArray;
    }

    addChargesToArray(typeId?: number, value?: number) {
        return this.formBuilder.group({
            chargeTypesId: [typeId ? typeId : null],
            chargeTypeCharge: [value ? value : null]
        });
    }

    addChargeTypeToArray(mainItem: LookUpModel, chargeValue?: string) {
        return this.formBuilder.group({
            typeId: [mainItem.id],
            name: [mainItem.name],
            value: [chargeValue ? chargeValue : 0]
        });
    }

    onOpenModel(content: TemplateRef<any>, providerScheduleCharge?: ProviderScheduleCharges) {
        this.buildForm();
        this.providerScheduleChargeForm.patchValue({ startDate: moment(this.todayDate).toString() });
        if (providerScheduleCharge != undefined) {
            this.fetchDoctorCharge(providerScheduleCharge);

        }

        if (providerScheduleCharge == undefined || providerScheduleCharge == null) {
            this.fetchAddChargeTypes();
        }
        this.modalRef = this.modalService.open(content, {
            backdrop: "static",
            keyboard: false,
            centered: true,
            windowClass: "custom-modal effect-scale"
        });
    }

    fetchDoctorCharge(providerScheduleCharge?: ProviderScheduleCharges) {
        const request = {}
        if (providerScheduleCharge != undefined) {
            request["providerId"] = providerScheduleCharge.providerId;
            request["specializationId"] = providerScheduleCharge.specializationId;
            request["startDate"] = providerScheduleCharge.startDate;
            request["endDate"] = providerScheduleCharge.endDate;
            request["consultationTypeId"] = providerScheduleCharge.consultationTypeId;
            request["active"] = providerScheduleCharge.active;
        }

        this.httpService
            .post<Array<ProviderScheduleCharges>>(ApiResources.getURI(ApiResources.providerScheduleCharges.base, ApiResources.providerScheduleCharges.doctorCharge), request)
            .pipe(takeUntil(this.page.unSubscribe))
            .pipe(finalize(() => this.loading = false))
            .subscribe(
                (response: Array<ProviderScheduleCharges>) => {
                    this.doctorCharges = response;

                    let abc = [] // provider availability charge types with values

                    for (var item of response) {
                        abc.push({ id: item.id, name: item.name, value: item.value, providerAvailabilityChargeTypeId: item.providerAvailabilityChargeTypeId });
                    }
                    console.log(abc);
                    let charge = [] //charge types from masters for OP 

                    for (var chargeType of this.charges) {
                        charge.push({ id: chargeType.id, name: chargeType.name, value: 0, providerAvailabilityChargeTypeId: 0 })
                    }

                    charge.forEach(x => { // values which are not present in abc and present in charge pushed to abc.
                        if (!abc.find(y => y.id === x.id)) {
                            abc.push(x);
                        }
                    });

                    if (providerScheduleCharge) {
                        abc.forEach((item) => {
                            this.forms.chargeArray.push(this.buildChargeForm(item));
                        });
                        this.doctorCharges.forEach((data) => {
                            this.providerScheduleChargeForm.patchValue({
                                providerId: data.providerId,
                                specializationId: data.specializationId,
                                startDate: data.startDate,
                                endDate: data.endDate,
                                partsOfDayId: data.partsOfDayId,
                                providerAvailabilityChargeTypeId: data.providerAvailabilityChargeTypeId,
                                locationId: data.locationId,
                                consultationTypeId: data.consultationTypeId,
                                followUpDays: data.followUpDays ? data.followUpDays : 0,
                                followUpDaysLimit: data.followUpDaysLimit ? data.followUpDaysLimit : 0,

                            })
                        })
                    }

                },
                () => {
                    this.doctorCharges = new Array<ProviderScheduleCharges>();
                }
            );
    }

    onChangeLocation(event?: IResource) {
        this.locationId = event.id;
        this.fetchDoctorSpecialization(null)
        this.fetchLocationSpecialization(event.id);
        this.fetchProviders(event.id);
    }
    onChangeFilterLocation(event?: IResource) {
        this.locationId = event.id;
        this.fetchLocationSpecialization(event.id);
        this.fetchProviders(event.id);
    }

    fetchProviderScheduleCharges() {
        this.loading = true;

        const request = Object.assign(UtilHelper.clone(this.filters.options), UtilHelper.clone(this.pagination));
        if (this.filters.options.toDate < this.filters.options.fromDate) {
            this.notifyService.warningToast("end should not be lessthan start date");
            return;
        }
        if (!request.locationId) {
            request.locationId = this.page.userAccount.locationId;
        }
        //if (!request.providerId) {
        //    request.specializationId = null;
        //}

        this.providerSchedulerCharges = new Array<ProviderScheduleCharges>();
        this.providerSchedulerChargeType = new Array<ProviderScheduleCharges>();
        this.httpService
            .post<Array<ProviderScheduleCharges>>(ApiResources.getURI(ApiResources.providerScheduleCharges.base, ApiResources.providerScheduleCharges.fetch), request)
            .pipe(takeUntil(this.page.unSubscribe))
            .pipe(finalize(() => this.loading = false))
            .subscribe(
                (response: any) => {

                    this.providerSchedulerCharges = response.item1;
                    this.providerSchedulerChargeType = response.item2;
                    UtilHelper.applyPagination(this.providerSchedulerCharges, this.pagination);
                    this.fetchProviderResources();
                    this.fetchspecializationForProviderAvialability();
                },
                () => {
                    this.providerSchedulerCharges = [];
                }
            );
    }


    onChangeProvider(p: ProviderSpecialization) {
       this.filters.options.specializationId = p.specializationId;
       // console.log(a);
    }
   
    onNextPage() {
        $("body,html").animate({ scrollTop: 0 });
        this.fetchProviderScheduleCharges();
    }

    onSubmit() {
        this.submitted = true;
        if (!this.providerScheduleChargeForm.valid) {
            this.notifyService.warningToast("Please fill all the fields.");
            return;
        }
        if (this.providerScheduleChargeForm.value.endDate < this.providerScheduleChargeForm.value.startDate) {
            this.notifyService.warningToast("end should not be lessthan start end");
            return;
        }
        const request = Object.assign(UtilHelper.clone(this.providerScheduleChargeForm.getRawValue()));
        let abc = request.charges.filter(m => m.value == null);
        if (abc.length > 0) {
            return this.notifyService.warningToast("Please provide Charge amount");
        }
        request["modifiedByName"] = this.page.userAccount.fullName;
        request["charges"] = this.providerScheduleChargeForm.value.charges;

        request.createdBy = this.page.userAccount.accountId;
        if (request["providerAvailabilityChargeTypeId"] > 0) {
            request["modifiedBy"] = this.page.userAccount.accountId;
        }
        this.submitting = true;
        var url = ApiResources.getURI(ApiResources.providerScheduleCharges.base, ApiResources.providerScheduleCharges.add);
        if (request["providerAvailabilityChargeTypeId"] > 0) {
            url = ApiResources.getURI(ApiResources.providerScheduleCharges.base, ApiResources.providerScheduleCharges.update);
        }
        this.httpService.post(url, request)
            .pipe(takeUntil(this.page.unSubscribe))
            .pipe(finalize(() => {
                this.submitting = false;
                this.submitted = false;
            }))
            .subscribe(() => {
                this.onCloseModal();
                this.fetchProviderScheduleCharges();
                this.notifyService.success("provider Schedule Charges has been saved successfully.");
            }, (error: HttpErrorResponse) => {
                const errorMessage = UtilHelper.handleError(error);
                if (errorMessage) {
                    this.notifyService.warningToast(errorMessage);
                } else {
                    this.notifyService.defaultError();
                }
            });
    }

    fetchDays() {
        const request = {};
        this.httpService
            .post<Array<partsOfDay>>(ApiResources.getURI(ApiResources.providerScheduleCharges.base, ApiResources.providerScheduleCharges.dayTypes), request)
            .pipe(takeUntil(this.page.unSubscribe))
            .pipe(finalize(() => this.loading = false))
            .subscribe(
                (response: Array<partsOfDay>) => {
                    this.days = response;

                },
                () => {
                    this.days = new Array<partsOfDay>();
                }
            );
    }

    get forms() {
        return {
            form: this.providerScheduleChargeForm ? this.providerScheduleChargeForm.controls : {},
            chargeArray: this.providerScheduleChargeForm.controls["charges"] as FormArray,
        }
    }

    private buildChargeForm(charge: any) {
        return this.formBuilder.group({
            id: charge.id,
            name: charge.name,
            value: charge.value ? charge.value : 0,
            providerAvailabilityChargeTypeId: charge.providerAvailabilityChargeTypeId ? charge.providerAvailabilityChargeTypeId : 0
        });
    }

    onCloseModal() {
        try {
            this.modalRef.close();
            this.modalRef = undefined;
        } catch (e) {
            // ignored;
        }
        this.loading = false;
        this.submitting = undefined;
        this.submitted = undefined;
    }

    ngOnInit() {
        this.appData.userAccount
            .pipe(takeUntil(this.page.unSubscribe))
            .subscribe((userAccount: IUserAccount) => {
                if (userAccount) {
                    this.page.userAccount = userAccount;
                    this.buildForm();
                    this.fetchLocations();
                    this.fetchProviderScheduleCharges();
                    this.fetchDoctorSpecialization();
                    this.fetchProviderSpecializations();
                    this.fetchDays();
                    this.fetchProviders(this.page.userAccount.locationId);
                    this.fetchConsultationType();
                    this.fetchProviderResources();
                    this.fetchspecializationForProviderAvialability();
                    this.fetchAddChargeTypes();
                    this.fetchLocationSpecialization(this.page.userAccount.locationId);
                } else {
                    this.page.userAccount = undefined;
                }
            });
    }

    private fetchLocations() {
        this.resourceService.locations()
            .pipe(takeUntil(this.page.unSubscribe))
            .subscribe((response: Array<IResource>) => {
                this.locations = response;
                this.filters.options.locationId = this.page.userAccount.locationId;

            });
    }

    fetchAddChargeTypes() {
        this.httpService
            .post<GenericResponse>(ApiResources.getURI(ApiResources.providerLocations.base, ApiResources.providerLocations.fetchChargeType), {})
            .pipe(takeUntil(this.page.unSubscribe))
            .pipe(finalize(() => this.loading = false))
            .subscribe(
                (response: GenericResponse) => {
                    this.charges = response.data as Array<LookUpModel>;
                    this.charges.forEach((charge) => {
                        //this.addChargeToForm(charge);
                        const item = {
                            id: charge.id,
                            name: charge.name,
                            value: charge.value ? charge.value : 0
                        };

                        this.forms.chargeArray.push(this.buildChargeForm(item));
                    });
                },
                () => {
                    this.charges = new Array<LookUpModel>();
                }
            );
    }

    private fetchDoctorSpecialization(locationId?: number) {

        this.loading = true;
        var request = {            
            locationId: locationId
        }

        this.httpService
            .post<Array<ProviderSpecialization>>(ApiResources.getURI(ApiResources.providerScheduleCharges.base, ApiResources.providerScheduleCharges.fetchProviderSpecialization), request)
            .pipe(takeUntil(this.page.unSubscribe))
            .pipe(finalize(() => this.loading = false))
            .subscribe(
                (response: Array<ProviderSpecialization>) => {
                    this.providerSpecialization = response;
                },
                () => {
                    this.providerSpecialization = new Array<ProviderSpecialization>();
                }
            );
    }

    private fetchConsultationType() {
        this.loadingconsultationTypes = true;        
        this.resourceService.consultationType()
            .pipe(takeUntil(this.page.unSubscribe))
            .subscribe((response: Array<IResource>) => {
                this.loadingconsultationTypes = false;
                this.consultationType = response;
            });
    }

    customSearch(term: string, item) {

        term = term.toLocaleLowerCase();
        return item['fullName'].toLocaleLowerCase().indexOf(term) > -1 || item['specializationName'].toLocaleLowerCase().indexOf(term) > -1;
    }

    onApplyFilters() {
        this.filters.applied = UtilHelper.isFiltersApplied(this.filters.options);
        this.initPagination();
        this.loading = true;
        this.fetchProviderScheduleCharges();
    }

    onResetFilters() {
        this.filters.init();
        this.loading = true;
        this.filters.options.locationId = this.page.userAccount.locationId;
        //this.setMaxDate = DateHelper.ngbToday;
        //this.setMinDate = DateHelper.ngbToday;
        this.fetchProviderScheduleCharges();
    }

    onChangeStatus(record: ProviderScheduleCharges, status: boolean) {

        const request = {
            schedulerTypeId: record.schedulerTypeId,
            active: status,
            modifiedBy: this.page.userAccount.accountId,
            roleId: this.page.userAccount.roleId
        };
        this.notifyService.confirm(`Do you really want to ${status ? "Active" : "Inactive"} this selected Charges?`, () => {
            this.modifying = true;
            this.modifyingContent = `${status ? "activating" : "inactivating"} the selected Component`;
            this.httpService
                .post(ApiResources.getURI(ApiResources.providerScheduleCharges.base, ApiResources.providerScheduleCharges.modifyStatus), request)
                .pipe(takeUntil(this.page.unSubscribe))
                .pipe(finalize(() => { this.modifying = false }))
                .subscribe(
                    (response: number) => {
                        if (response > 0) {
                            switch (response) {
                                case 1:
                                    this.notifyService.successToast("Status is updated successfully.");
                                    this.fetchProviderScheduleCharges();
                            }
                        }
                        this.fetchProviderScheduleCharges();

                    },
                    () => {

                    }
                );

        }, () => {

        });
    }

    private fetchProviders(locationId?: number) {
        this.loadingProviders = true;
        this.resourceService.locationProviders(locationId)
            .pipe(finalize(() => { this.loadingProviders = false }))
            .pipe(takeUntil(this.page.unSubscribe))
            .subscribe((response: Array<IResource>) => {
                this.providers = response;
            });
    }

    private fetchLocationSpecialization(locationId?: number) {
        this.loadingSpecialization = true
        this.resourceService.locationSpecializations(locationId)
            .pipe(finalize(() => { this.loadingSpecialization = false }))
            .pipe(takeUntil(this.page.unSubscribe))
            .subscribe((response: Array<IResource>) => {
                this.specializations = response;
            });
    }

    private fetchProviderSpecializations(providerId?: number) {
        this.loadingSpecialization = true
        this.resourceService.providerSpecializations(providerId)
            .pipe(finalize(() => { this.loadingSpecialization = false }))
            .pipe(takeUntil(this.page.unSubscribe))
            .subscribe((response: Array<IResource>) => {
                this.specializations = response;
            });
    }

    ngOnDestroy() {
        this.onCloseModal();
        this.page.unsubscribeAll();
        this.todayDate = null;
        this.setDate = null;
        this.setDate1 = null;
    }

    getEndDate() {
        //this.greaterThanToday = this.providerScheduleChargeForm.value.startDate;
        //this.providerScheduleChargeForm.patchValue({ endDate: this.providerScheduleChargeForm.value.startDate });
        const date = this.providerScheduleChargeForm.get("startDate").value.split("-");
            const year = Number(date[0]);
            const month = Number(date[1]);
        const day = Number(date[2]);
        this.setDate1 = new NgbDate(year, month, day);
        //this.providerScheduleChargeForm.get("endDate").setValue(disableDate);
        ////this.providerScheduleChargeForm.setValue("endDate") = disableDate;
        //this.providerScheduleChargeForm.patchValue({ endDate: disableDate });
    }

    dateValidation() {
        if (this.providerScheduleChargeForm.value.endDate < this.providerScheduleChargeForm.value.startDate) {
            this.notifyService.warningToast("end should not be lessthan start end");
            return;
        }
    }

    fetchDoctorSpecializationHelper($event: any) {
        if ($event && $event.term && $event.term.length > 1) {
           // let locationId = this.quickScheduleForm.get("locationId").value
          //  let consultationTypeId = this.quickScheduleForm.get("consultationTypeId").value
            this.fetchDoctorSpecialization(this.page.userAccount.locationId);
        } else {
            this.providerSpecialization = new Array<ProviderSpecialization>();
        }
    }
}