﻿import { RepeatType } from "./repeat-type.model";
import { AutomaticType } from "./automatic-type.model";
import { DiscountType } from "./discount-type.model";

export interface IChargeModel {
    chargeId: number;
    productId: number;
    cost: number;
    opCost: number;
    chargeName: string;
    chargeGroupName: string;
    departmentName: string;

    serviceOrderId: number;
    unit: number;
    totalCost: number;
    discountAmount: number;
    discountPercentage: number;
    discountType: DiscountType;
    discount: number;
    status: boolean;
    repeatTypeId: RepeatType;
    automaticTypeId: AutomaticType;

    active: boolean;
    createdDate: Date;
    modifiedDate: Date;
    createdByName: string;
    modifiedByName: string;

    isMain: boolean;

    departmentId: number;
    chargeGroupId: number;

    repeatTypeName: string;
    automaticTypeName: string;

    deleting: boolean;

    totalItems: number;

    chargeTypeMainId: number;
    chargeTypeMainName: string;

    chargeTypeId: number;
    chargeTypeName: string;

    // Package Module
    showAmount: boolean;
    isInPackage: boolean;
    admissionPackageId?: number;
    packageModuleDetailId?: number;
    usedQuantity?: number;
    usedCost?: number;

    modulesMasterId?: number;
}