﻿import { RepeatType } from "./repeat-type.model";
import { AutomaticType } from "./automatic-type.model";

export interface ILabServicesModel {
    labServicesId: number;
    labBookingHeaderId?: number;
    labBookingDetailId?: number;
    labStatus: string;
    isReportGenerated?: boolean;
    isSampleCollected?: boolean;
    reportDate?: Date;
    labHeaderId: number;
    labName: string;
    labCode: string;
    charge: number;

    mrp: number;
    cost: number;

    isSelected: boolean;

    labPackageDetailId: number;
    labPackageId: number;
    testParameter: string;
    labData: Array<string>;

    unit: number;
    totalCost: number;
    discountAmount: number;
    discountPercentage: number;
    status: boolean;
    repeatTypeId: RepeatType;
    automaticTypeId: AutomaticType;

    active: boolean;
    createdDate: Date;
    modifiedDate: Date;
    createdByName: string;
    modifiedByName: string;

    isMain: boolean;

    repeatTypeName: string;
    automaticTypeName: string;

    deleting: boolean;

    totalItems: number;

    signature: string;
    createdBy: number;
    noOfParameter: number;
    inPatientCharge: number;
    modifiedBy?: number;
    netAmount: number;
    showAmount: boolean;
    labExitsInPackage: boolean;
}