﻿import { RepeatType } from "./repeat-type.model";
import { AutomaticType } from "./automatic-type.model";
import { DiscountType } from "./discount-type.model";

export class NewLabServicesModel {
    labServicesId: number;
    newLabBookingHeaderId?: number;
    newLabBookingDetailId?: number;
    labStatus: string;
    isReportGenerated?: boolean;
    isSampleCollected?: boolean;
    reportDate?: Date;
    labMainDetailId: number;
    testName: string;
    testCode: string;
    charge: number;

    mrp: number;
    cost: number;

    isSelected: boolean;

    labPackageDetailId: number;
    labPackageId: number;
    testParameter: string;
    labData: Array<string>;

    unit: number;
    totalCost: number;
    discountAmount: number;
    discountPercentage: number;
    discountType: DiscountType;
    discount: number;
    status: boolean;
    repeatTypeId: RepeatType;
    automaticTypeId: AutomaticType;

    active: boolean;
    createdByName: string;
    modifiedByName: string;

    isMain: boolean;

    repeatTypeName: string;
    automaticTypeName: string;

    deleting: boolean;

    totalItems: number;

    signature: string;
    createdBy: number;
    noOfParameter: number;
    inPatientCharge: number;
    modifiedBy?: number;
    netAmount: number;
    showAmount: boolean;
    labExitsInPackage: boolean;

    labDepartmentId: number;
    labSampleTypeId: number;
    typeName: string;
    departmentName: string;
    joined: string;
    isInternalLab: boolean;
    isExternalLab: boolean;

    createdDate: Date;
    modifiedDate?: Date;

    charges: Array<LabMainDetailCharge>;
    templates: Array<LabMainDetailTemplate>;
    isLoading: boolean;
    patientLabDetailId?: number;
    chargeExistForCurrentLocation?: number;
    chargesSet?: boolean;
    selected: boolean;
    chargeCategoryId?: number;

    modulesMasterId?: number;

    // Package Module
    isInPackage: boolean;
    admissionPackageId?: number;
    packageModuleDetailId?: number;
    usedQuantity?: number;
    usedCost?: number;

    constructor() {
        this.charges = new Array<LabMainDetailCharge>();
        this.templates = new Array<LabMainDetailTemplate>();
    }
}
export class LabMainDetailCharge {
    labMainDetailChargeId: number;
    labMainDetailId: number;
    chargeCategoryId: number;
    rate?: number;
    amount?: number;
    locationId: number;
    locationName: string;
    chargeCategoryName: string;
    default: boolean;

    modulesMasterId?: number;
}

export class LabMainDetailTemplate {
    labMainDetailTemplateId: number;
    labMainDetailId: number;
    labTemplateHeaderId: number;
    priority: number;
    templateName: string;
    templateId: string;
}