﻿namespace Hims.Shared.EntityModels
{
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// The coupon.
    /// </summary>
    public class DepartmentModel
    {
        /// <summary>
        /// Gets or sets the bed id.
        /// </summary>
        public int DepartmentId { get; set; }
              

        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public string DepartmentName { get; set; }

        /// <summary>
        /// Gets or sets the bed id.
        /// </summary>
        public int Cost { get; set; }

        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public string ChargeGroupName { get; set; }

        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public string ChargeName { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the name of the modified by.
        /// </summary>
        /// <value>
        /// The name of the modified by.
        /// </value>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified by role.
        /// </summary>
        /// <value>
        /// The modified by role.
        /// </value>
        public string ModifiedByRole { get; set; }

        /// <summary>
        /// Gets or sets the created by role.
        /// </summary>
        /// <value>
        /// The created by role.
        /// </value>
        public string CreatedByRole { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }


        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public int TotalItems { get; set; }


        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int PageSize { get; set; }

        /// <summary>
        /// Gets or Sets the Ward Name.
        /// </summary>
        public string? WardName { get; set; }
        
        /// <summary>
        /// Gets or sets the location ids.
        /// </summary>
        /// <value>
        /// The location ids.
        /// </value>
        public string LocationIds { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the name of the location.
        /// </summary>
        /// <value>
        /// The name of the location.
        /// </value>
        public string LocationNames { get; set; }

        /// <summary>
        /// Gets or sets the allowed user.
        /// </summary>
        /// <value>
        /// The allowed user.
        /// </value>
        public string AllowedUser { get; set; }

        /// <summary>
        /// Gets or sets the name of the module.
        /// </summary>
        /// <value>
        /// The name of the module.
        /// </value>
        public string ModuleName { get; set; }
        /// <summary>
        /// Gets or sets the name of the module.
        /// </summary>
        /// <value>
        /// The name of the module.
        /// </value>
        public string DeptType { get; set; }
        
    }   
}
