﻿namespace Hims.Shared.UserModels.Scan.ScanSubClassification
{
    using Hims.Shared.Dapper.Attributes;
    using System;
    using System.Collections.Generic;
    using System.ComponentModel.DataAnnotations;

    /// <summary>
    /// The Id Proof Identifier
    /// </summary>
#pragma warning disable S101 // Types should be named in PascalCase
    public class InsertModel
#pragma warning restore S101 // Types should be named in PascalCase
    {
        /// <summary>
        /// Gets or sets the scan classification id.
        /// </summary>
        /// <value>
        /// The Id proof identifier.
        /// </value>
        public int ScanSubClassificationId { get; set; }
        /// <summary>
        /// Gets or sets the scan classification id.
        /// </summary>
        /// <value>
        /// The Id proof identifier.
        /// </value>
        public int ScanClassificationId { get; set; }

        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the name of the scan classification.
        /// </summary>
        /// <value>
        /// The name of the scan classification.
        /// </value>
        public string ScanSubClassificationName { get; set; }

        /// <summary>
        /// Gets or sets the name of the modify name.
        /// </summary>
        /// <value>
        /// The name of the modify name.
        /// </value>
        public string ModifiedByName { get; set; }



        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="ScanClassification"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the login Role value id.
        /// </summary>
        public int? LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }

        public List<DetailModel> Details { get; set; }

    }
    public class DetailModel
    {

        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public string ScanSubClassificationName { get; set; }
       
        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ScanSubClassificationId { get; set; }

        /// <summary>
        /// Gets or sets the scan classification id.
        /// </summary>
        /// <value>
        /// The Id proof identifier.
        /// </value>
        public int ScanClassificationId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="ScanClassification"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

    }
}
